/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ILightsManager
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.lights.ILightsManager";

    @EnforcePermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public List<Light> getLights() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public LightState getLightState(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public void openSession(IBinder var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public void closeSession(IBinder var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public void setLightStates(IBinder var1, int[] var2, LightState[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILightsManager {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_getLights = 1;
        static final int TRANSACTION_getLightState = 2;
        static final int TRANSACTION_openSession = 3;
        static final int TRANSACTION_closeSession = 4;
        static final int TRANSACTION_setLightStates = 5;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, ILightsManager.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static ILightsManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILightsManager.DESCRIPTOR);
            if (iin != null && iin instanceof ILightsManager) {
                return (ILightsManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getLights";
                }
                case 2: {
                    return "getLightState";
                }
                case 3: {
                    return "openSession";
                }
                case 4: {
                    return "closeSession";
                }
                case 5: {
                    return "setLightStates";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILightsManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    List<Light> _result = this.getLights();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    LightState _result = this.getLightState(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.openSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.closeSession(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    int[] _arg1 = data.createIntArray();
                    LightState[] _arg2 = data.createTypedArray(LightState.CREATOR);
                    data.enforceNoDataAvail();
                    this.setLightStates(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void getLights_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DEVICE_LIGHTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getLightState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DEVICE_LIGHTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void openSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DEVICE_LIGHTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void closeSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DEVICE_LIGHTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setLightStates_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DEVICE_LIGHTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ILightsManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILightsManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Light> getLights() throws RemoteException {
                ArrayList<Light> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Light.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LightState getLightState(int lightId) throws RemoteException {
                LightState _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeInt(lightId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(LightState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openSession(IBinder sessionToken, int priority) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(priority);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSession(IBinder sessionToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLightStates(IBinder sessionToken, int[] lightIds, LightState[] states) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILightsManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeIntArray(lightIds);
                    _data.writeTypedArray(states, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILightsManager {
        @Override
        public List<Light> getLights() throws RemoteException {
            return null;
        }

        @Override
        public LightState getLightState(int lightId) throws RemoteException {
            return null;
        }

        @Override
        public void openSession(IBinder sessionToken, int priority) throws RemoteException {
        }

        @Override
        public void closeSession(IBinder sessionToken) throws RemoteException {
        }

        @Override
        public void setLightStates(IBinder sessionToken, int[] lightIds, LightState[] states) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

