/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.chre.flags.Flags;
import android.content.Context;
import android.hardware.contexthub.HubDiscoveryInfo;
import android.hardware.contexthub.HubEndpoint;
import android.hardware.contexthub.HubEndpointDiscoveryCallback;
import android.hardware.contexthub.HubEndpointInfo;
import android.hardware.contexthub.HubServiceInfo;
import android.hardware.contexthub.IContextHubEndpointDiscoveryCallback;
import android.hardware.location.ContextHubClient;
import android.hardware.location.ContextHubClientCallback;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.ContextHubTransaction;
import android.hardware.location.ContextHubTransactionHelper;
import android.hardware.location.HubInfo;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubClient;
import android.hardware.location.IContextHubClientCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.IContextHubTransactionCallback;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppBinary;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.hardware.location.NanoAppMessage;
import android.hardware.location.NanoAppState;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

@SystemApi
public class ContextHubManager {
    private static final String TAG = "ContextHubManager";
    public static final String EXTRA_CLIENT_AUTHORIZATION_STATE = "android.hardware.location.extra.CLIENT_AUTHORIZATION_STATE";
    public static final String EXTRA_CONTEXT_HUB_INFO = "android.hardware.location.extra.CONTEXT_HUB_INFO";
    public static final String EXTRA_EVENT_TYPE = "android.hardware.location.extra.EVENT_TYPE";
    public static final String EXTRA_NANOAPP_ID = "android.hardware.location.extra.NANOAPP_ID";
    public static final String EXTRA_NANOAPP_ABORT_CODE = "android.hardware.location.extra.NANOAPP_ABORT_CODE";
    public static final String EXTRA_MESSAGE = "android.hardware.location.extra.MESSAGE";
    public static final int AUTHORIZATION_DENIED = 0;
    public static final int AUTHORIZATION_DENIED_GRACE_PERIOD = 1;
    public static final int AUTHORIZATION_GRANTED = 2;
    public static final int EVENT_NANOAPP_LOADED = 0;
    public static final int EVENT_NANOAPP_UNLOADED = 1;
    public static final int EVENT_NANOAPP_ENABLED = 2;
    public static final int EVENT_NANOAPP_DISABLED = 3;
    public static final int EVENT_NANOAPP_ABORTED = 4;
    public static final int EVENT_NANOAPP_MESSAGE = 5;
    public static final int EVENT_HUB_RESET = 6;
    public static final int EVENT_CLIENT_AUTHORIZATION = 7;
    private final Looper mMainLooper;
    private final IContextHubService mService;
    private Callback mCallback;
    private Handler mCallbackHandler;
    private Map<HubEndpointDiscoveryCallback, IContextHubEndpointDiscoveryCallback> mDiscoveryCallbacks = new ConcurrentHashMap<HubEndpointDiscoveryCallback, IContextHubEndpointDiscoveryCallback>();
    @Deprecated
    private ICallback mLocalCallback;
    private final IContextHubCallback.Stub mClientCallback = new IContextHubCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageReceipt(int hubId, int nanoAppId, ContextHubMessage message) {
            ContextHubManager contextHubManager = ContextHubManager.this;
            synchronized (contextHubManager) {
                if (ContextHubManager.this.mCallback != null) {
                    ContextHubManager.this.mCallbackHandler.post(() -> ContextHubManager.this.invokeOnMessageReceiptCallback(hubId, nanoAppId, message));
                } else if (ContextHubManager.this.mLocalCallback != null) {
                    ContextHubManager.this.mLocalCallback.onMessageReceipt(hubId, nanoAppId, message);
                }
            }
        }
    };

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public int[] getContextHubHandles() {
        if (Flags.removeOldContextHubApis()) {
            return null;
        }
        try {
            return this.mService.getContextHubHandles();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public ContextHubInfo getContextHubInfo(int hubHandle) {
        if (Flags.removeOldContextHubApis()) {
            return null;
        }
        try {
            return this.mService.getContextHubInfo(hubHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public int loadNanoApp(int hubHandle, @NonNull NanoApp app) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        try {
            return this.mService.loadNanoApp(hubHandle, app);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public int unloadNanoApp(int nanoAppHandle) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        try {
            return this.mService.unloadNanoApp(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @Nullable
    public NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) {
        if (Flags.removeOldContextHubApis()) {
            return null;
        }
        try {
            return this.mService.getNanoAppInstanceInfo(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public int[] findNanoAppOnHub(int hubHandle, @NonNull NanoAppFilter filter) {
        if (Flags.removeOldContextHubApis()) {
            return null;
        }
        try {
            return this.mService.findNanoAppOnHub(hubHandle, filter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    public int sendMessage(int hubHandle, int nanoAppHandle, @NonNull ContextHubMessage message) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        try {
            return this.mService.sendMessage(hubHandle, nanoAppHandle, message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public List<ContextHubInfo> getContextHubs() {
        try {
            return this.mService.getContextHubs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    @FlaggedApi(value="android.chre.flags.offload_api")
    public List<HubInfo> getHubs() {
        try {
            return this.mService.getHubs();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IContextHubTransactionCallback createQueryCallback(final ContextHubTransaction<List<NanoAppState>> transaction) {
        return new IContextHubTransactionCallback.Stub(this){

            @Override
            public void onQueryResponse(int result, List<NanoAppState> nanoappList) {
                transaction.setResponse(new ContextHubTransaction.Response<List<NanoAppState>>(result, nanoappList));
            }

            @Override
            public void onTransactionComplete(int result) {
                Log.e(ContextHubManager.TAG, "Received a non-query callback on a query request");
                transaction.setResponse(new ContextHubTransaction.Response<Object>(7, null));
            }
        };
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubTransaction<Void> loadNanoApp(@NonNull ContextHubInfo hubInfo, @NonNull NanoAppBinary appBinary) {
        Objects.requireNonNull(hubInfo, "ContextHubInfo cannot be null");
        Objects.requireNonNull(appBinary, "NanoAppBinary cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(0);
        IContextHubTransactionCallback callback = ContextHubTransactionHelper.createTransactionCallback(transaction);
        try {
            this.mService.loadNanoAppOnHub(hubInfo.getId(), callback, appBinary);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubTransaction<Void> unloadNanoApp(@NonNull ContextHubInfo hubInfo, long nanoAppId) {
        Objects.requireNonNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(1);
        IContextHubTransactionCallback callback = ContextHubTransactionHelper.createTransactionCallback(transaction);
        try {
            this.mService.unloadNanoAppFromHub(hubInfo.getId(), callback, nanoAppId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubTransaction<Void> enableNanoApp(@NonNull ContextHubInfo hubInfo, long nanoAppId) {
        Objects.requireNonNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(2);
        IContextHubTransactionCallback callback = ContextHubTransactionHelper.createTransactionCallback(transaction);
        try {
            this.mService.enableNanoApp(hubInfo.getId(), callback, nanoAppId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubTransaction<Void> disableNanoApp(@NonNull ContextHubInfo hubInfo, long nanoAppId) {
        Objects.requireNonNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<Void> transaction = new ContextHubTransaction<Void>(3);
        IContextHubTransactionCallback callback = ContextHubTransactionHelper.createTransactionCallback(transaction);
        try {
            this.mService.disableNanoApp(hubInfo.getId(), callback, nanoAppId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubTransaction<List<NanoAppState>> queryNanoApps(@NonNull ContextHubInfo hubInfo) {
        Objects.requireNonNull(hubInfo, "ContextHubInfo cannot be null");
        ContextHubTransaction<List<NanoAppState>> transaction = new ContextHubTransaction<List<NanoAppState>>(4);
        IContextHubTransactionCallback callback = this.createQueryCallback(transaction);
        try {
            this.mService.queryNanoApps(hubInfo.getId(), callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return transaction;
    }

    @FlaggedApi(value="android.chre.flags.offload_api")
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public List<HubDiscoveryInfo> findEndpoints(long endpointId) {
        try {
            List<HubEndpointInfo> endpointInfos = this.mService.findEndpoints(endpointId);
            ArrayList<HubDiscoveryInfo> results = new ArrayList<HubDiscoveryInfo>(endpointInfos.size());
            for (HubEndpointInfo endpointInfo : endpointInfos) {
                results.add(new HubDiscoveryInfo(endpointInfo));
            }
            return results;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.chre.flags.offload_api")
    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public List<HubDiscoveryInfo> findEndpoints(@NonNull String serviceDescriptor) {
        if (serviceDescriptor.isBlank()) {
            throw new IllegalArgumentException("Invalid service descriptor: " + serviceDescriptor);
        }
        try {
            List<HubEndpointInfo> endpointInfos = this.mService.findEndpointsWithService(serviceDescriptor);
            ArrayList<HubDiscoveryInfo> results = new ArrayList<HubDiscoveryInfo>(endpointInfos.size());
            for (HubEndpointInfo endpointInfo : endpointInfos) {
                for (HubServiceInfo serviceInfo : endpointInfo.getServiceInfoCollection()) {
                    if (!serviceInfo.getServiceDescriptor().equals(serviceDescriptor)) continue;
                    results.add(new HubDiscoveryInfo(endpointInfo, serviceInfo));
                }
            }
            return results;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.chre.flags.offload_api")
    private IContextHubEndpointDiscoveryCallback createDiscoveryCallback(final IContextHubService service, final Executor executor, final HubEndpointDiscoveryCallback callback, final @Nullable String serviceDescriptor) {
        return new IContextHubEndpointDiscoveryCallback.Stub(){

            @Override
            public void onEndpointsStarted(HubEndpointInfo[] hubEndpointInfoList) {
                if (hubEndpointInfoList.length == 0) {
                    Log.w(ContextHubManager.TAG, "onEndpointsStarted: received empty discovery list");
                    this.invokeCallbackFinished(service);
                    return;
                }
                executor.execute(() -> {
                    List<HubDiscoveryInfo> discoveryList = ContextHubManager.this.getMatchingEndpointDiscoveryList(hubEndpointInfoList, serviceDescriptor);
                    if (discoveryList.isEmpty()) {
                        Log.w(ContextHubManager.TAG, "onEndpointsStarted: no matching service descriptor");
                    } else {
                        callback.onEndpointsStarted(discoveryList);
                    }
                    this.invokeCallbackFinished(service);
                });
            }

            @Override
            public void onEndpointsStopped(HubEndpointInfo[] hubEndpointInfoList, int reason) {
                if (hubEndpointInfoList.length == 0) {
                    Log.w(ContextHubManager.TAG, "onEndpointsStopped: received empty discovery list");
                    this.invokeCallbackFinished(service);
                    return;
                }
                executor.execute(() -> {
                    List<HubDiscoveryInfo> discoveryList = ContextHubManager.this.getMatchingEndpointDiscoveryList(hubEndpointInfoList, serviceDescriptor);
                    if (discoveryList.isEmpty()) {
                        Log.w(ContextHubManager.TAG, "onEndpointsStopped: no matching service descriptor");
                    } else {
                        callback.onEndpointsStopped(discoveryList, reason);
                    }
                    this.invokeCallbackFinished(service);
                });
            }

            private void invokeCallbackFinished(IContextHubService service2) {
                try {
                    service2.onDiscoveryCallbackFinished();
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        };
    }

    @FlaggedApi(value="android.chre.flags.offload_api")
    private List<HubDiscoveryInfo> getMatchingEndpointDiscoveryList(HubEndpointInfo[] hubEndpointInfoList, @Nullable String serviceDescriptor) {
        ArrayList<HubDiscoveryInfo> discoveryList = new ArrayList<HubDiscoveryInfo>(hubEndpointInfoList.length);
        for (HubEndpointInfo info : hubEndpointInfoList) {
            if (serviceDescriptor != null) {
                for (HubServiceInfo sInfo : info.getServiceInfoCollection()) {
                    if (!sInfo.getServiceDescriptor().equals(serviceDescriptor)) continue;
                    discoveryList.add(new HubDiscoveryInfo(info, sInfo));
                }
                continue;
            }
            discoveryList.add(new HubDiscoveryInfo(info));
        }
        return discoveryList;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void registerEndpointDiscoveryCallback(@NonNull HubEndpointDiscoveryCallback callback, long endpointId) {
        this.registerEndpointDiscoveryCallback((Executor)new HandlerExecutor(Handler.getMain()), callback, endpointId);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void registerEndpointDiscoveryCallback(@NonNull Executor executor, @NonNull HubEndpointDiscoveryCallback callback, long endpointId) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        IContextHubEndpointDiscoveryCallback iCallback = this.createDiscoveryCallback(this.mService, executor, callback, null);
        try {
            this.mService.registerEndpointDiscoveryCallbackId(endpointId, iCallback);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        this.mDiscoveryCallbacks.put(callback, iCallback);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void registerEndpointDiscoveryCallback(@NonNull HubEndpointDiscoveryCallback callback, @NonNull String serviceDescriptor) {
        this.registerEndpointDiscoveryCallback((Executor)new HandlerExecutor(Handler.getMain()), callback, serviceDescriptor);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void registerEndpointDiscoveryCallback(@NonNull Executor executor, @NonNull HubEndpointDiscoveryCallback callback, @NonNull String serviceDescriptor) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        Objects.requireNonNull(serviceDescriptor, "serviceDescriptor cannot be null");
        if (serviceDescriptor.isBlank()) {
            throw new IllegalArgumentException("Invalid service descriptor: " + serviceDescriptor);
        }
        IContextHubEndpointDiscoveryCallback iCallback = this.createDiscoveryCallback(this.mService, executor, callback, serviceDescriptor);
        try {
            this.mService.registerEndpointDiscoveryCallbackDescriptor(serviceDescriptor, iCallback);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        this.mDiscoveryCallbacks.put(callback, iCallback);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void unregisterEndpointDiscoveryCallback(@NonNull HubEndpointDiscoveryCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        IContextHubEndpointDiscoveryCallback iCallback = this.mDiscoveryCallbacks.remove(callback);
        if (iCallback == null) {
            throw new IllegalArgumentException("Callback not previously registered");
        }
        try {
            this.mService.unregisterEndpointDiscoveryCallback(iCallback);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public int registerCallback(@NonNull Callback callback) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        return this.registerCallback(callback, null);
    }

    @Deprecated
    public int registerCallback(ICallback callback) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        if (this.mLocalCallback != null) {
            Log.w(TAG, "Max number of local callbacks reached!");
            return -1;
        }
        this.mLocalCallback = callback;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public int registerCallback(Callback callback, Handler handler) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (this.mCallback != null) {
                Log.w(TAG, "Max number of callbacks reached!");
                return -1;
            }
            this.mCallback = callback;
            this.mCallbackHandler = handler == null ? new Handler(this.mMainLooper) : handler;
        }
        return 0;
    }

    private IContextHubClientCallback createClientCallback(final ContextHubClient client, final ContextHubClientCallback callback, final Executor executor) {
        return new IContextHubClientCallback.Stub(this){

            @Override
            public void onMessageFromNanoApp(NanoAppMessage message) {
                executor.execute(() -> {
                    callback.onMessageFromNanoApp(client, message);
                    if (message.isReliable()) {
                        client.reliableMessageCallbackFinished(message.getMessageSequenceNumber(), (byte)0);
                    } else {
                        client.callbackFinished();
                    }
                });
            }

            @Override
            public void onHubReset() {
                executor.execute(() -> {
                    callback.onHubReset(client);
                    client.callbackFinished();
                });
            }

            @Override
            public void onNanoAppAborted(long nanoAppId, int abortCode) {
                executor.execute(() -> {
                    callback.onNanoAppAborted(client, nanoAppId, abortCode);
                    client.callbackFinished();
                });
            }

            @Override
            public void onNanoAppLoaded(long nanoAppId) {
                executor.execute(() -> {
                    callback.onNanoAppLoaded(client, nanoAppId);
                    client.callbackFinished();
                });
            }

            @Override
            public void onNanoAppUnloaded(long nanoAppId) {
                executor.execute(() -> {
                    callback.onNanoAppUnloaded(client, nanoAppId);
                    client.callbackFinished();
                });
            }

            @Override
            public void onNanoAppEnabled(long nanoAppId) {
                executor.execute(() -> {
                    callback.onNanoAppEnabled(client, nanoAppId);
                    client.callbackFinished();
                });
            }

            @Override
            public void onNanoAppDisabled(long nanoAppId) {
                executor.execute(() -> {
                    callback.onNanoAppDisabled(client, nanoAppId);
                    client.callbackFinished();
                });
            }

            @Override
            public void onClientAuthorizationChanged(long nanoAppId, int authorization) {
                executor.execute(() -> {
                    callback.onClientAuthorizationChanged(client, nanoAppId, authorization);
                    client.callbackFinished();
                });
            }
        };
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubClient createClient(@Nullable Context context, @NonNull ContextHubInfo hubInfo, @NonNull Executor executor, @NonNull ContextHubClientCallback callback) {
        IContextHubClient clientProxy;
        Objects.requireNonNull(callback, "Callback cannot be null");
        Objects.requireNonNull(hubInfo, "ContextHubInfo cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        ContextHubClient client = new ContextHubClient(hubInfo, false);
        IContextHubClientCallback clientInterface = this.createClientCallback(client, callback, executor);
        String attributionTag = null;
        if (context != null) {
            attributionTag = context.getAttributionTag();
        }
        String packageName = context != null ? context.getPackageName() : ActivityThread.currentPackageName();
        try {
            clientProxy = this.mService.createClient(hubInfo.getId(), clientInterface, attributionTag, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        client.setClientProxy(clientProxy);
        return client;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubClient createClient(@NonNull ContextHubInfo hubInfo, @NonNull ContextHubClientCallback callback, @NonNull Executor executor) {
        return this.createClient(null, hubInfo, executor, callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubClient createClient(@NonNull ContextHubInfo hubInfo, @NonNull ContextHubClientCallback callback) {
        return this.createClient(null, hubInfo, new HandlerExecutor(Handler.getMain()), callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubClient createClient(@Nullable Context context, @NonNull ContextHubInfo hubInfo, @NonNull PendingIntent pendingIntent, long nanoAppId) {
        IContextHubClient clientProxy;
        Objects.requireNonNull(pendingIntent);
        Objects.requireNonNull(hubInfo);
        if (pendingIntent.isImmutable()) {
            throw new IllegalArgumentException("PendingIntent must be mutable");
        }
        ContextHubClient client = new ContextHubClient(hubInfo, true);
        String attributionTag = null;
        if (context != null) {
            attributionTag = context.getAttributionTag();
        }
        try {
            clientProxy = this.mService.createPendingIntentClient(hubInfo.getId(), pendingIntent, nanoAppId, attributionTag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        client.setClientProxy(clientProxy);
        return client;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public ContextHubClient createClient(@NonNull ContextHubInfo hubInfo, @NonNull PendingIntent pendingIntent, long nanoAppId) {
        return this.createClient(null, hubInfo, pendingIntent, nanoAppId);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void registerEndpoint(@NonNull HubEndpoint hubEndpoint) {
        hubEndpoint.register(this.mService);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void openSession(@NonNull HubEndpoint hubEndpoint, @NonNull HubEndpointInfo destination) {
        hubEndpoint.openSession(destination, null);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void openSession(@NonNull HubEndpoint hubEndpoint, @NonNull HubEndpointInfo destination, @NonNull String serviceDescriptor) {
        hubEndpoint.openSession(destination, serviceDescriptor);
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @FlaggedApi(value="android.chre.flags.offload_api")
    public void unregisterEndpoint(@NonNull HubEndpoint hubEndpoint) {
        hubEndpoint.unregister();
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public long[] getPreloadedNanoAppIds(@NonNull ContextHubInfo hubInfo) {
        Objects.requireNonNull(hubInfo, "hubInfo cannot be null");
        long[] nanoappIds = null;
        try {
            nanoappIds = this.mService.getPreloadedNanoAppIds(hubInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (nanoappIds == null) {
            nanoappIds = new long[]{};
        }
        return nanoappIds;
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public boolean enableTestMode() {
        try {
            return this.mService.setTestMode(true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_CONTEXT_HUB")
    @NonNull
    public boolean disableTestMode() {
        try {
            return this.mService.setTestMode(false);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public int unregisterCallback(@NonNull Callback callback) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (callback != this.mCallback) {
                Log.w(TAG, "Cannot recognize callback!");
                return -1;
            }
            this.mCallback = null;
            this.mCallbackHandler = null;
        }
        return 0;
    }

    @Deprecated
    public synchronized int unregisterCallback(ICallback callback) {
        if (Flags.removeOldContextHubApis()) {
            return -1;
        }
        if (callback != this.mLocalCallback) {
            Log.w(TAG, "Cannot recognize local callback!");
            return -1;
        }
        this.mLocalCallback = null;
        return 0;
    }

    private synchronized void invokeOnMessageReceiptCallback(int hubId, int nanoAppId, ContextHubMessage message) {
        if (this.mCallback != null) {
            this.mCallback.onMessageReceipt(hubId, nanoAppId, message);
        }
    }

    public ContextHubManager(@NonNull IContextHubService service, @NonNull Looper mainLooper) {
        Objects.requireNonNull(service, "service cannot be null");
        Objects.requireNonNull(mainLooper, "mainLooper cannot be null");
        this.mService = service;
        this.mMainLooper = mainLooper;
        try {
            this.mService.registerCallback(this.mClientCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public static abstract class Callback {
        protected Callback() {
        }

        public abstract void onMessageReceipt(int var1, int var2, @NonNull ContextHubMessage var3);
    }

    @Deprecated
    public static interface ICallback {
        public void onMessageReceipt(int var1, int var2, ContextHubMessage var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Event {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthorizationState {
    }
}

