/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Bitmap;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioTuner;
import android.hardware.radio.TunerCallbackAdapter;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.hardware.radio.Flags;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class TunerAdapter
extends RadioTuner {
    private static final String TAG = "BroadcastRadio.TunerAdapter";
    private final ITuner mTuner;
    private final TunerCallbackAdapter mCallback;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mIsClosed;
    @GuardedBy(value={"mLock"})
    private int mBand;
    @GuardedBy(value={"mLock"})
    private ProgramList mLegacyListProxy;
    @GuardedBy(value={"mLock"})
    private Map<String, String> mLegacyListFilter;

    TunerAdapter(ITuner tuner, TunerCallbackAdapter callback, int band) {
        this.mTuner = Objects.requireNonNull(tuner, "Tuner cannot be null");
        this.mCallback = Objects.requireNonNull(callback, "Callback cannot be null");
        this.mBand = band;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                Log.v(TAG, "Tuner is already closed");
                return;
            }
            this.mIsClosed = true;
            if (this.mLegacyListProxy != null) {
                this.mLegacyListProxy.close();
                this.mLegacyListProxy = null;
            }
        }
        this.mCallback.close();
        try {
            this.mTuner.close();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception trying to close tuner", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setConfiguration(RadioManager.BandConfig config) {
        if (config == null) {
            return -22;
        }
        try {
            this.mTuner.setConfiguration(config);
            Object object = this.mLock;
            synchronized (object) {
                this.mBand = config.getType();
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Can't set configuration", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
    }

    @Override
    public int getConfiguration(RadioManager.BandConfig[] config) {
        if (config == null || config.length != 1) {
            throw new IllegalArgumentException("The argument must be an array of length 1");
        }
        try {
            config[0] = this.mTuner.getConfiguration();
            return 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
    }

    @Override
    public int setMute(boolean mute) {
        try {
            this.mTuner.setMuted(mute);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't set muted", e);
            return Integer.MIN_VALUE;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public boolean getMute() {
        try {
            return this.mTuner.isMuted();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return true;
        }
    }

    @Override
    public int step(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.step(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't step", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public int scan(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.seek(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't scan", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public int seek(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.seek(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't seek", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tune(int channel, int subChannel) {
        try {
            int band;
            Object object = this.mLock;
            synchronized (object) {
                band = this.mBand;
            }
            this.mTuner.tune(ProgramSelector.createAmFmSelector(band, channel, subChannel));
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't tune", e);
            return -38;
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Can't tune", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public void tune(ProgramSelector selector) {
        try {
            this.mTuner.tune(selector);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public int cancel() {
        try {
            this.mTuner.cancel();
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Can't cancel", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Service died", e);
            return -32;
        }
        return 0;
    }

    @Override
    public void cancelAnnouncement() {
        try {
            this.mTuner.cancelAnnouncement();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public int getProgramInformation(RadioManager.ProgramInfo[] info) {
        if (info == null || info.length != 1) {
            Log.e(TAG, "The argument must be an array of length 1");
            return -22;
        }
        RadioManager.ProgramInfo current = this.mCallback.getCurrentProgramInformation();
        if (current == null) {
            Log.w(TAG, "Didn't get program info yet");
            return -38;
        }
        info[0] = current;
        return 0;
    }

    @Override
    @NonNull
    public Bitmap getMetadataImage(int id2) {
        if (id2 == 0) {
            throw new IllegalArgumentException("Invalid metadata image id 0");
        }
        try {
            Bitmap bitmap = this.mTuner.getImage(id2);
            if (bitmap == null) {
                throw new IllegalArgumentException("Metadata image with id " + id2 + " is not available");
            }
            return bitmap;
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public boolean startBackgroundScan() {
        try {
            return this.mTuner.startBackgroundScan();
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RadioManager.ProgramInfo> getProgramList(@Nullable Map<String, String> vendorFilter) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLegacyListProxy == null || !Objects.equals(this.mLegacyListFilter, vendorFilter)) {
                Log.i(TAG, "Program list filter has changed, requesting new list");
                this.mLegacyListProxy = new ProgramList();
                this.mLegacyListFilter = vendorFilter;
                this.mCallback.clearLastCompleteList();
                this.mCallback.setProgramListObserver(this.mLegacyListProxy, () -> Log.i(TAG, "Empty closeListener in programListObserver"));
            }
        }
        try {
            this.mTuner.startProgramListUpdates(new ProgramList.Filter(vendorFilter));
        }
        catch (RemoteException ex) {
            throw new RuntimeException("Service died", ex);
        }
        List<RadioManager.ProgramInfo> list = this.mCallback.getLastCompleteList();
        if (list == null) {
            throw new IllegalStateException("Program list is not ready yet");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ProgramList getDynamicProgramList(@Nullable ProgramList.Filter filter) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLegacyListProxy != null) {
                this.mLegacyListProxy.close();
                this.mLegacyListProxy = null;
            }
            this.mLegacyListFilter = null;
        }
        ProgramList list = new ProgramList();
        this.mCallback.setProgramListObserver(list, () -> {
            try {
                this.mTuner.stopProgramListUpdates();
            }
            catch (IllegalStateException ex) {
                Log.e(TAG, "Tuner may already be closed", ex);
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Couldn't stop program list updates", ex);
            }
        });
        try {
            this.mTuner.startProgramListUpdates(filter);
        }
        catch (UnsupportedOperationException ex) {
            Log.i(TAG, "Program list is not supported with this hardware");
            return null;
        }
        catch (RemoteException ex) {
            this.mCallback.setProgramListObserver(null, () -> Log.i(TAG, "Empty closeListener in programListObserver"));
            throw new RuntimeException("Service died", ex);
        }
        return list;
    }

    @Override
    public boolean isAnalogForced() {
        try {
            return this.isConfigFlagSet(2);
        }
        catch (UnsupportedOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void setAnalogForced(boolean isForced) {
        try {
            this.setConfigFlag(2, isForced);
        }
        catch (UnsupportedOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public boolean isConfigFlagSupported(int flag) {
        try {
            return this.mTuner.isConfigFlagSupported(flag);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public boolean isConfigFlagSet(int flag) {
        try {
            return this.mTuner.isConfigFlagSet(this.convertForceAnalogConfigFlag(flag));
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public void setConfigFlag(int flag, boolean value) {
        try {
            this.mTuner.setConfigFlag(this.convertForceAnalogConfigFlag(flag), value);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public Map<String, String> setParameters(Map<String, String> parameters) {
        try {
            return this.mTuner.setParameters(Objects.requireNonNull(parameters, "Parameters cannot be null"));
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public Map<String, String> getParameters(List<String> keys) {
        try {
            return this.mTuner.getParameters(Objects.requireNonNull(keys, "Keys cannot be null"));
        }
        catch (RemoteException e) {
            throw new RuntimeException("Service died", e);
        }
    }

    @Override
    public boolean isAntennaConnected() {
        return this.mCallback.isAntennaConnected();
    }

    @Override
    public boolean hasControl() {
        try {
            return !this.mTuner.isClosed();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private int convertForceAnalogConfigFlag(int flag) throws RemoteException {
        if (Flags.hdRadioImproved() && flag == 2 && this.mTuner.isConfigFlagSupported(10)) {
            flag = 10;
        }
        return flag;
    }
}

