/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.radio.ProgramSelector;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class UniqueProgramIdentifier
implements Parcelable {
    @NonNull
    private final ProgramSelector.Identifier mPrimaryId;
    @NonNull
    private final ProgramSelector.Identifier[] mCriticalSecondaryIds;
    @NonNull
    public static final Parcelable.Creator<UniqueProgramIdentifier> CREATOR = new Parcelable.Creator<UniqueProgramIdentifier>(){

        @Override
        public UniqueProgramIdentifier createFromParcel(Parcel in) {
            return new UniqueProgramIdentifier(in);
        }

        public UniqueProgramIdentifier[] newArray(int size) {
            return new UniqueProgramIdentifier[size];
        }
    };

    public static boolean requireCriticalSecondaryIds(int type) {
        return type == 14 || type == 5;
    }

    public UniqueProgramIdentifier(ProgramSelector selector) {
        Objects.requireNonNull(selector, "Program selector can not be null");
        this.mPrimaryId = selector.getPrimaryId();
        switch (this.mPrimaryId.getType()) {
            case 5: 
            case 14: {
                ProgramSelector.Identifier ensembleId = null;
                ProgramSelector.Identifier frequencyId = null;
                ProgramSelector.Identifier[] secondaryIds = selector.getSecondaryIds();
                for (int i = 0; i < secondaryIds.length; ++i) {
                    if (ensembleId == null && secondaryIds[i].getType() == 6) {
                        ensembleId = selector.getSecondaryIds()[i];
                    } else if (frequencyId == null && secondaryIds[i].getType() == 8) {
                        frequencyId = secondaryIds[i];
                    }
                    if (ensembleId != null && frequencyId != null) break;
                }
                if (ensembleId == null) {
                    if (frequencyId == null) {
                        this.mCriticalSecondaryIds = new ProgramSelector.Identifier[0];
                        break;
                    }
                    this.mCriticalSecondaryIds = new ProgramSelector.Identifier[]{frequencyId};
                    break;
                }
                if (frequencyId == null) {
                    this.mCriticalSecondaryIds = new ProgramSelector.Identifier[]{ensembleId};
                    break;
                }
                this.mCriticalSecondaryIds = new ProgramSelector.Identifier[]{ensembleId, frequencyId};
                break;
            }
            default: {
                this.mCriticalSecondaryIds = new ProgramSelector.Identifier[0];
            }
        }
    }

    public UniqueProgramIdentifier(ProgramSelector.Identifier primaryId) {
        this.mPrimaryId = primaryId;
        this.mCriticalSecondaryIds = new ProgramSelector.Identifier[0];
    }

    @NonNull
    public ProgramSelector.Identifier getPrimaryId() {
        return this.mPrimaryId;
    }

    @NonNull
    public List<ProgramSelector.Identifier> getCriticalSecondaryIds() {
        return List.of(this.mCriticalSecondaryIds);
    }

    @NonNull
    public String toString() {
        return "UniqueProgramIdentifier(primary=" + this.mPrimaryId + ", criticalSecondary=" + Arrays.toString(this.mCriticalSecondaryIds) + ")";
    }

    public int hashCode() {
        return Objects.hash(this.mPrimaryId, Arrays.hashCode(this.mCriticalSecondaryIds));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UniqueProgramIdentifier)) {
            return false;
        }
        UniqueProgramIdentifier other = (UniqueProgramIdentifier)obj;
        return other.mPrimaryId.equals(this.mPrimaryId) && Arrays.equals(other.mCriticalSecondaryIds, this.mCriticalSecondaryIds);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private UniqueProgramIdentifier(Parcel in) {
        this.mPrimaryId = in.readTypedObject(ProgramSelector.Identifier.CREATOR);
        this.mCriticalSecondaryIds = in.createTypedArray(ProgramSelector.Identifier.CREATOR);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mPrimaryId, 0);
        dest.writeTypedArray(this.mCriticalSecondaryIds, 0);
        if (Stream.of(this.mCriticalSecondaryIds).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("criticalSecondaryIds list must not contain nulls");
        }
    }
}

