/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.health.connect.TimeRangeFilter;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.util.ArraySet;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class DeleteUsingFiltersRequest {
    private final TimeRangeFilter mTimeRangeFilter;
    private final Set<Class<? extends Record>> mRecordTypes;
    private final Set<DataOrigin> mDataOrigins;

    private DeleteUsingFiltersRequest(@Nullable TimeRangeFilter timeRangeFilter, @NonNull Set<Class<? extends Record>> recordTypes, @NonNull Set<DataOrigin> dataOrigins) {
        Objects.requireNonNull(recordTypes);
        Objects.requireNonNull(dataOrigins);
        this.mTimeRangeFilter = timeRangeFilter;
        this.mRecordTypes = recordTypes;
        this.mDataOrigins = dataOrigins;
    }

    @NonNull
    public Set<Class<? extends Record>> getRecordTypes() {
        return this.mRecordTypes;
    }

    @Nullable
    public TimeRangeFilter getTimeRangeFilter() {
        return this.mTimeRangeFilter;
    }

    @NonNull
    public Set<DataOrigin> getDataOrigins() {
        return this.mDataOrigins;
    }

    public static class Builder {
        private final Set<DataOrigin> mDataOrigins = new ArraySet<DataOrigin>();
        private final Set<Class<? extends Record>> mRecordTypes = new ArraySet<Class<? extends Record>>();
        private TimeRangeFilter mTimeRangeFilter;

        @NonNull
        public Builder addDataOrigin(@NonNull DataOrigin dataOrigin) {
            Objects.requireNonNull(dataOrigin);
            this.mDataOrigins.add(dataOrigin);
            return this;
        }

        @NonNull
        public Builder clearDataOrigins() {
            this.mDataOrigins.clear();
            return this;
        }

        @NonNull
        public Builder setTimeRangeFilter(@Nullable TimeRangeFilter timeRangeFilter) {
            this.mTimeRangeFilter = timeRangeFilter;
            return this;
        }

        @NonNull
        public Builder addRecordType(@NonNull Class<? extends Record> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordTypes.add(recordType);
            return this;
        }

        @NonNull
        public Builder clearRecordTypes() {
            this.mRecordTypes.clear();
            return this;
        }

        @NonNull
        public DeleteUsingFiltersRequest build() {
            return new DeleteUsingFiltersRequest(this.mTimeRangeFilter, this.mRecordTypes, this.mDataOrigins);
        }
    }
}

