/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.health.connect.ReadRecordsRequest;
import android.health.connect.RecordIdFilter;
import android.health.connect.aidl.ReadRecordsRequestParcel;
import android.health.connect.datatypes.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReadRecordsRequestUsingIds<T extends Record>
extends ReadRecordsRequest<T> {
    private final List<RecordIdFilter> mRecordIdFiltersList;

    private ReadRecordsRequestUsingIds(@NonNull Class<T> recordType, @NonNull List<RecordIdFilter> recordIdFiltersList) {
        super(recordType);
        Objects.requireNonNull(recordIdFiltersList);
        this.mRecordIdFiltersList = recordIdFiltersList;
    }

    @NonNull
    public List<RecordIdFilter> getRecordIdFilters() {
        return this.mRecordIdFiltersList;
    }

    @Override
    @NonNull
    public ReadRecordsRequestParcel toReadRecordsRequestParcel() {
        return new ReadRecordsRequestParcel(this);
    }

    public static class Builder<T extends Record> {
        private final Class<T> mRecordType;
        private final List<RecordIdFilter> mRecordIdFiltersList = new ArrayList<RecordIdFilter>();

        public Builder(@NonNull Class<T> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordType = recordType;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder<T> addId(@NonNull String id2) {
            if (this.mRecordIdFiltersList.size() >= 5000) {
                throw new IllegalArgumentException("Maximum allowed pageSize is 5000");
            }
            this.mRecordIdFiltersList.add(RecordIdFilter.fromId(this.mRecordType, id2));
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder<T> addClientRecordId(@NonNull String clientRecordId) {
            if (this.mRecordIdFiltersList.size() >= 5000) {
                throw new IllegalArgumentException("Maximum allowed pageSize is 5000");
            }
            this.mRecordIdFiltersList.add(RecordIdFilter.fromClientRecordId(this.mRecordType, clientRecordId));
            return this;
        }

        @NonNull
        public ReadRecordsRequestUsingIds<T> build() {
            if (this.mRecordIdFiltersList.isEmpty()) {
                throw new IllegalArgumentException("RecordIdFilter list is empty, Either record id or client record id must be set");
            }
            return new ReadRecordsRequestUsingIds<T>(this.mRecordType, this.mRecordIdFiltersList);
        }
    }
}

