/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.AggregateRecordsRequest;
import android.health.connect.LocalTimeRangeFilter;
import android.health.connect.TimeInstantRangeFilter;
import android.health.connect.TimeRangeFilter;
import android.health.connect.TimeRangeFilterHelper;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.DataOrigin;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.util.List;
import java.util.stream.Collectors;

public class AggregateDataRequestParcel
implements Parcelable {
    public static final Parcelable.Creator<AggregateDataRequestParcel> CREATOR = new Parcelable.Creator<AggregateDataRequestParcel>(){

        @Override
        public AggregateDataRequestParcel createFromParcel(Parcel in) {
            return new AggregateDataRequestParcel(in);
        }

        public AggregateDataRequestParcel[] newArray(int size) {
            return new AggregateDataRequestParcel[size];
        }
    };
    private final long mStartTime;
    private final long mEndTime;
    private final int[] mAggregateIds;
    private final List<String> mPackageFilters;
    private Duration mDuration;
    private Period mPeriod;
    private final boolean mLocalTimeFilter;

    public AggregateDataRequestParcel(AggregateRecordsRequest<?> request) {
        this.mStartTime = TimeRangeFilterHelper.getFilterStartTimeMillis(request.getTimeRangeFilter());
        this.mEndTime = TimeRangeFilterHelper.getFilterEndTimeMillis(request.getTimeRangeFilter());
        this.mAggregateIds = new int[request.getAggregationTypes().size()];
        this.mLocalTimeFilter = TimeRangeFilterHelper.isLocalTimeFilter(request.getTimeRangeFilter());
        int i = 0;
        for (AggregationType<?> aggregationType : request.getAggregationTypes()) {
            this.mAggregateIds[i++] = aggregationType.getAggregationTypeIdentifier();
        }
        this.mPackageFilters = request.getDataOriginsFilters().stream().map(DataOrigin::getPackageName).collect(Collectors.toList());
        this.mDuration = Duration.ofMillis(this.mEndTime - this.mStartTime);
    }

    public AggregateDataRequestParcel(AggregateRecordsRequest request, Duration duration) {
        this(request);
        this.mDuration = duration;
    }

    public AggregateDataRequestParcel(AggregateRecordsRequest request, Period period) {
        this(request);
        this.mDuration = null;
        this.mPeriod = period;
        if (!TimeRangeFilterHelper.isLocalTimeFilter(request.getTimeRangeFilter())) {
            throw new UnsupportedOperationException("For period requests should use LocalTimeRangeFilter");
        }
    }

    protected AggregateDataRequestParcel(Parcel in) {
        long duration;
        this.mStartTime = in.readLong();
        this.mEndTime = in.readLong();
        this.mLocalTimeFilter = in.readBoolean();
        this.mAggregateIds = in.createIntArray();
        this.mPackageFilters = in.createStringArrayList();
        int periodDays = in.readInt();
        if (periodDays != -1) {
            int periodMonths = in.readInt();
            int periodYears = in.readInt();
            this.mPeriod = Period.of(periodYears, periodMonths, periodDays);
        }
        if ((duration = in.readLong()) != -1L) {
            this.mDuration = Duration.ofMillis(duration);
        }
    }

    @Nullable
    public Duration getDuration() {
        return this.mDuration;
    }

    @Nullable
    public Period getPeriod() {
        return this.mPeriod;
    }

    public boolean useLocalTimeFilter() {
        return this.mLocalTimeFilter;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mStartTime);
        dest.writeLong(this.mEndTime);
        dest.writeBoolean(this.mLocalTimeFilter);
        dest.writeIntArray(this.mAggregateIds);
        dest.writeStringList(this.mPackageFilters);
        if (this.mPeriod != null) {
            dest.writeInt(this.mPeriod.getDays());
            dest.writeInt(this.mPeriod.getMonths());
            dest.writeInt(this.mPeriod.getYears());
        } else {
            dest.writeInt(-1);
        }
        if (this.mDuration != null) {
            dest.writeLong(this.mDuration.toMillis());
        } else {
            dest.writeLong(-1L);
        }
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public int[] getAggregateIds() {
        return this.mAggregateIds;
    }

    @NonNull
    public List<String> getPackageFilters() {
        return this.mPackageFilters;
    }

    @NonNull
    public TimeRangeFilter getTimeRangeFilter() {
        if (this.mLocalTimeFilter) {
            return new LocalTimeRangeFilter.Builder().setStartTime(TimeRangeFilterHelper.getLocalTimeFromMillis(this.mStartTime)).setEndTime(TimeRangeFilterHelper.getLocalTimeFromMillis(this.mEndTime)).build();
        }
        return new TimeInstantRangeFilter.Builder().setStartTime(Instant.ofEpochMilli(this.mStartTime)).setEndTime(Instant.ofEpochMilli(this.mEndTime)).build();
    }
}

