/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.AggregateRecordsGroupedByDurationResponse;
import android.health.connect.AggregateRecordsGroupedByPeriodResponse;
import android.health.connect.AggregateRecordsResponse;
import android.health.connect.LocalTimeRangeFilter;
import android.health.connect.TimeInstantRangeFilter;
import android.health.connect.TimeRangeFilter;
import android.health.connect.TimeRangeFilterHelper;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.internal.datatypes.utils.AggregationTypeIdMapper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AggregateDataResponseParcel
implements Parcelable {
    public static final Parcelable.Creator<AggregateDataResponseParcel> CREATOR = new Parcelable.Creator<AggregateDataResponseParcel>(){

        @Override
        public AggregateDataResponseParcel createFromParcel(Parcel in) {
            return new AggregateDataResponseParcel(in);
        }

        public AggregateDataResponseParcel[] newArray(int size) {
            return new AggregateDataResponseParcel[size];
        }
    };
    private final List<AggregateRecordsResponse<?>> mAggregateRecordsResponses;
    private Duration mDuration;
    private Period mPeriod;
    private TimeRangeFilter mTimeRangeFilter;

    public AggregateDataResponseParcel(List<AggregateRecordsResponse<?>> aggregateRecordsResponse) {
        this.mAggregateRecordsResponses = aggregateRecordsResponse;
    }

    protected AggregateDataResponseParcel(Parcel in) {
        long duration;
        int size = in.readInt();
        this.mAggregateRecordsResponses = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            int mapSize = in.readInt();
            ArrayMap result = new ArrayMap(mapSize);
            for (int mapI = 0; mapI < mapSize; ++mapI) {
                int id2 = in.readInt();
                boolean hasValue = in.readBoolean();
                if (hasValue) {
                    result.put(id2, AggregationTypeIdMapper.getInstance().getAggregateResultFor(id2, in).setZoneOffset(this.parseZoneOffset(in)).setDataOrigins(in.createStringArrayList()));
                    continue;
                }
                result.put(id2, null);
            }
            this.mAggregateRecordsResponses.add(new AggregateRecordsResponse(result));
        }
        int periodDays = in.readInt();
        if (periodDays != -1) {
            int periodMonths = in.readInt();
            int periodYears = in.readInt();
            this.mPeriod = Period.of(periodYears, periodMonths, periodDays);
        }
        if ((duration = in.readLong()) != -1L) {
            this.mDuration = Duration.ofMillis(duration);
        }
        boolean isLocaltimeFilter = in.readBoolean();
        long startTime = in.readLong();
        long endTime = in.readLong();
        if (startTime != -1L && endTime != -1L) {
            this.mTimeRangeFilter = isLocaltimeFilter ? new LocalTimeRangeFilter.Builder().setStartTime(TimeRangeFilterHelper.getLocalTimeFromMillis(startTime)).setEndTime(TimeRangeFilterHelper.getLocalTimeFromMillis(endTime)).build() : new TimeInstantRangeFilter.Builder().setStartTime(Instant.ofEpochMilli(startTime)).setEndTime(Instant.ofEpochMilli(endTime)).build();
        }
    }

    public AggregateDataResponseParcel setDuration(@Nullable Duration duration, @Nullable TimeRangeFilter timeRangeFilter) {
        this.mDuration = duration;
        this.mTimeRangeFilter = timeRangeFilter;
        return this;
    }

    public AggregateDataResponseParcel setPeriod(@Nullable Period period, @Nullable TimeRangeFilter timeRangeFilter) {
        this.mPeriod = period;
        this.mTimeRangeFilter = timeRangeFilter;
        return this;
    }

    public AggregateRecordsResponse<?> getAggregateDataResponse() {
        return this.mAggregateRecordsResponses.get(0);
    }

    public List<AggregateRecordsGroupedByDurationResponse<?>> getAggregateDataResponseGroupedByDuration() {
        Objects.requireNonNull(this.mDuration);
        if (this.mAggregateRecordsResponses.isEmpty()) {
            return List.of();
        }
        TimeRangeFilter timeRangeFilter = this.mTimeRangeFilter;
        if (timeRangeFilter instanceof LocalTimeRangeFilter) {
            LocalTimeRangeFilter timeFilter = (LocalTimeRangeFilter)timeRangeFilter;
            return this.getAggregateDataResponseForLocalTimeGroupedByDuration(timeFilter.getStartTime(), timeFilter.getEndTime());
        }
        timeRangeFilter = this.mTimeRangeFilter;
        if (timeRangeFilter instanceof TimeInstantRangeFilter) {
            TimeInstantRangeFilter timeFilter = (TimeInstantRangeFilter)timeRangeFilter;
            return this.getAggregateDataResponseForInstantTimeGroupedByDuration(timeFilter.getStartTime(), timeFilter.getEndTime());
        }
        throw new IllegalArgumentException("Invalid time filter object. Object should be either TimeInstantRangeFilter or LocalTimeRangeFilter.");
    }

    private List<AggregateRecordsGroupedByDurationResponse<?>> getAggregateDataResponseForLocalTimeGroupedByDuration(LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList responses = new ArrayList();
        Duration bucketStartTimeOffset = Duration.ZERO;
        for (AggregateRecordsResponse<?> response : this.mAggregateRecordsResponses) {
            ZoneOffset zoneOffset = response.getFirstZoneOffset();
            Instant endTimeInstant = TimeRangeFilterHelper.getInstantFromLocalTime(endTime, zoneOffset);
            Instant bucketStartTime = TimeRangeFilterHelper.getInstantFromLocalTime(startTime, zoneOffset).plus(bucketStartTimeOffset);
            Instant bucketEndTime = bucketStartTime.plus(this.mDuration);
            if (bucketEndTime.isAfter(endTimeInstant)) {
                bucketEndTime = endTimeInstant;
            }
            responses.add(new AggregateRecordsGroupedByDurationResponse(bucketStartTime, bucketEndTime, response.getAggregateResults()));
            bucketStartTimeOffset = bucketStartTimeOffset.plus(this.mDuration);
        }
        return responses;
    }

    private List<AggregateRecordsGroupedByDurationResponse<?>> getAggregateDataResponseForInstantTimeGroupedByDuration(Instant startTime, Instant endTime) {
        ArrayList responses = new ArrayList();
        Duration offsetDuration = Duration.ZERO;
        for (AggregateRecordsResponse<?> response : this.mAggregateRecordsResponses) {
            Instant buckedStartTime = startTime.plus(offsetDuration);
            Instant buckedEndTime = buckedStartTime.plus(this.mDuration);
            if (buckedEndTime.isAfter(endTime)) {
                buckedEndTime = endTime;
            }
            responses.add(new AggregateRecordsGroupedByDurationResponse(buckedStartTime, buckedEndTime, response.getAggregateResults()));
            offsetDuration = offsetDuration.plus(this.mDuration);
        }
        return responses;
    }

    public List<AggregateRecordsGroupedByPeriodResponse<?>> getAggregateDataResponseGroupedByPeriod() {
        Objects.requireNonNull(this.mPeriod);
        ArrayList aggregateRecordsGroupedByPeriodResponses = new ArrayList();
        LocalDateTime groupBoundary = ((LocalTimeRangeFilter)this.mTimeRangeFilter).getStartTime();
        for (AggregateRecordsResponse<?> aggregateRecordsResponse : this.mAggregateRecordsResponses) {
            aggregateRecordsGroupedByPeriodResponses.add(new AggregateRecordsGroupedByPeriodResponse(groupBoundary, groupBoundary.plus(this.mPeriod), aggregateRecordsResponse.getAggregateResults()));
            groupBoundary = groupBoundary.plus(this.mPeriod);
        }
        if (!aggregateRecordsGroupedByPeriodResponses.isEmpty()) {
            ((AggregateRecordsGroupedByPeriodResponse)aggregateRecordsGroupedByPeriodResponses.get(aggregateRecordsGroupedByPeriodResponses.size() - 1)).setEndTime(this.getPeriodEndLocalDateTime(this.mTimeRangeFilter));
        }
        return aggregateRecordsGroupedByPeriodResponses;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAggregateRecordsResponses.size());
        for (AggregateRecordsResponse<?> aggregateRecordsResponse : this.mAggregateRecordsResponses) {
            dest.writeInt(aggregateRecordsResponse.getAggregateResults().size());
            aggregateRecordsResponse.getAggregateResults().forEach((key, val) -> {
                dest.writeInt((int)key);
                dest.writeBoolean(val != null);
                if (val != null) {
                    val.putToParcel(dest);
                    ZoneOffset zoneOffset = val.getZoneOffset();
                    if (zoneOffset != null) {
                        dest.writeInt(val.getZoneOffset().getTotalSeconds());
                    } else {
                        dest.writeInt(-1);
                    }
                    Set<DataOrigin> dataOrigins = val.getDataOrigins();
                    ArrayList<String> packageNames = new ArrayList<String>();
                    for (DataOrigin dataOrigin : dataOrigins) {
                        packageNames.add(dataOrigin.getPackageName());
                    }
                    dest.writeStringList(packageNames);
                }
            });
        }
        if (this.mPeriod != null) {
            dest.writeInt(this.mPeriod.getDays());
            dest.writeInt(this.mPeriod.getMonths());
            dest.writeInt(this.mPeriod.getYears());
        } else {
            dest.writeInt(-1);
        }
        if (this.mDuration != null) {
            dest.writeLong(this.mDuration.toMillis());
        } else {
            dest.writeLong(-1L);
        }
        if (this.mTimeRangeFilter != null) {
            dest.writeBoolean(TimeRangeFilterHelper.isLocalTimeFilter(this.mTimeRangeFilter));
            dest.writeLong(TimeRangeFilterHelper.getFilterStartTimeMillis(this.mTimeRangeFilter));
            dest.writeLong(TimeRangeFilterHelper.getFilterEndTimeMillis(this.mTimeRangeFilter));
        } else {
            dest.writeBoolean(false);
            dest.writeLong(-1L);
            dest.writeLong(-1L);
        }
    }

    private ZoneOffset parseZoneOffset(Parcel in) {
        int zoneOffsetInSecs = in.readInt();
        ZoneOffset zoneOffset = null;
        if (zoneOffsetInSecs != -1) {
            zoneOffset = ZoneOffset.ofTotalSeconds(zoneOffsetInSecs);
        }
        return zoneOffset;
    }

    private LocalDateTime getPeriodEndLocalDateTime(TimeRangeFilter timeRangeFilter) {
        if (timeRangeFilter instanceof TimeInstantRangeFilter) {
            return LocalDateTime.ofInstant(((TimeInstantRangeFilter)timeRangeFilter).getEndTime(), ZoneOffset.systemDefault());
        }
        if (timeRangeFilter instanceof LocalTimeRangeFilter) {
            return ((LocalTimeRangeFilter)timeRangeFilter).getEndTime();
        }
        throw new IllegalArgumentException("Invalid time filter object. Object should be either TimeInstantRangeFilter or LocalTimeRangeFilter.");
    }

    private long getPeriodDeltaInDays(Period period) {
        return period.getDays();
    }

    private Instant getDurationInstant(long duration) {
        return Instant.ofEpochMilli(duration);
    }

    private long getDurationDelta(Duration duration) {
        return duration.toMillis();
    }
}

