/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.NonNull;
import android.health.connect.ReadRecordsRequestUsingFilters;
import android.health.connect.ReadRecordsRequestUsingIds;
import android.health.connect.TimeRangeFilterHelper;
import android.health.connect.aidl.RecordIdFiltersParcel;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ReadRecordsRequestParcel
implements Parcelable {
    public static final Parcelable.Creator<ReadRecordsRequestParcel> CREATOR = new Parcelable.Creator<ReadRecordsRequestParcel>(){

        @Override
        public ReadRecordsRequestParcel createFromParcel(Parcel in) {
            return new ReadRecordsRequestParcel(in);
        }

        public ReadRecordsRequestParcel[] newArray(int size) {
            return new ReadRecordsRequestParcel[size];
        }
    };
    private final RecordIdFiltersParcel mRecordIdFiltersParcel;
    private final int mRecordType;
    private final List<String> mPackageFilters;
    private final long mStartTime;
    private final long mEndTime;
    private final int mPageSize;
    private final long mPageToken;
    private final boolean mAscending;
    private final boolean mLocalTimeFilter;

    protected ReadRecordsRequestParcel(Parcel in) {
        this.mRecordType = in.readInt();
        this.mStartTime = in.readLong();
        this.mEndTime = in.readLong();
        this.mLocalTimeFilter = in.readBoolean();
        this.mPackageFilters = in.createStringArrayList();
        this.mRecordIdFiltersParcel = in.readParcelable(RecordIdFiltersParcel.class.getClassLoader(), RecordIdFiltersParcel.class);
        this.mPageSize = in.readInt();
        this.mPageToken = in.readLong();
        this.mAscending = in.readBoolean();
    }

    public ReadRecordsRequestParcel(ReadRecordsRequestUsingIds<?> request) {
        this.mPackageFilters = Collections.emptyList();
        this.mRecordIdFiltersParcel = new RecordIdFiltersParcel(request.getRecordIdFilters());
        this.mStartTime = -1L;
        this.mEndTime = -1L;
        this.mRecordType = HealthConnectMappings.getInstance().getRecordType(request.getRecordType());
        this.mPageSize = -1;
        this.mLocalTimeFilter = false;
        this.mPageToken = -1L;
        this.mAscending = true;
    }

    public ReadRecordsRequestParcel(ReadRecordsRequestUsingFilters<?> request) {
        this.mPackageFilters = request.getDataOrigins().stream().map(DataOrigin::getPackageName).collect(Collectors.toList());
        this.mRecordIdFiltersParcel = null;
        if (request.getTimeRangeFilter() == null) {
            this.mStartTime = -1L;
            this.mEndTime = -1L;
        } else {
            this.mStartTime = TimeRangeFilterHelper.getFilterStartTimeMillis(request.getTimeRangeFilter());
            this.mEndTime = TimeRangeFilterHelper.getFilterEndTimeMillis(request.getTimeRangeFilter());
        }
        this.mLocalTimeFilter = TimeRangeFilterHelper.isLocalTimeFilter(request.getTimeRangeFilter());
        this.mRecordType = HealthConnectMappings.getInstance().getRecordType(request.getRecordType());
        this.mPageSize = request.getPageSize();
        this.mPageToken = request.getPageToken();
        this.mAscending = request.isAscending();
    }

    public int getRecordType() {
        return this.mRecordType;
    }

    public List<String> getPackageFilters() {
        return this.mPackageFilters;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public RecordIdFiltersParcel getRecordIdFiltersParcel() {
        return this.mRecordIdFiltersParcel;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public long getPageToken() {
        return this.mPageToken;
    }

    public boolean isAscending() {
        return this.mAscending;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean usesLocalTimeFilter() {
        return this.mLocalTimeFilter;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRecordType);
        dest.writeLong(this.mStartTime);
        dest.writeLong(this.mEndTime);
        dest.writeBoolean(this.mLocalTimeFilter);
        dest.writeStringList(this.mPackageFilters);
        dest.writeParcelable(this.mRecordIdFiltersParcel, 0);
        dest.writeInt(this.mPageSize);
        dest.writeLong(this.mPageToken);
        dest.writeBoolean(this.mAscending);
    }
}

