/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ActivityIntensityRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=42)
@FlaggedApi(value="com.android.healthfitness.flags.activity_intensity")
public class ActivityIntensityRecord
extends IntervalRecord {
    public static final int ACTIVITY_INTENSITY_TYPE_MODERATE = 0;
    public static final int ACTIVITY_INTENSITY_TYPE_VIGOROUS = 1;
    @NonNull
    public static final AggregationType<Duration> MODERATE_DURATION_TOTAL = new AggregationType<Duration>(88, 3, 42, Duration.class);
    @NonNull
    public static final AggregationType<Duration> VIGOROUS_DURATION_TOTAL = new AggregationType<Duration>(89, 3, 42, Duration.class);
    @NonNull
    public static final AggregationType<Duration> DURATION_TOTAL = new AggregationType<Duration>(90, 3, 42, Duration.class);
    @NonNull
    public static final AggregationType<Long> INTENSITY_MINUTES_TOTAL = new AggregationType<Long>(91, 3, 42, Long.class);
    private static final Set<Integer> VALID_ACTIVITY_INTENSITY_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1));
    private final int mActivityIntensityType;

    private ActivityIntensityRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, int activityIntensityType, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        if (!skipValidation) {
            ValidationUtils.validateIntDefValue(activityIntensityType, VALID_ACTIVITY_INTENSITY_TYPES, ActivityIntensityType.class.getSimpleName());
        }
        this.mActivityIntensityType = activityIntensityType;
    }

    public int getActivityIntensityType() {
        return this.mActivityIntensityType;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityIntensityRecord)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActivityIntensityRecord that = (ActivityIntensityRecord)o;
        return this.getActivityIntensityType() == that.getActivityIntensityType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getActivityIntensityType());
    }

    public ActivityIntensityRecordInternal toRecordInternal() {
        ActivityIntensityRecordInternal recordInternal = (ActivityIntensityRecordInternal)new ActivityIntensityRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        recordInternal.setActivityIntensityType(this.getActivityIntensityType());
        return recordInternal;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActivityIntensityType {
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private final int mActivityIntensityType;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, int activityIntensityType) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mActivityIntensityType = activityIntensityType;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public ActivityIntensityRecord buildWithoutValidation() {
            return new ActivityIntensityRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mActivityIntensityType, true);
        }

        @NonNull
        public ActivityIntensityRecord build() {
            return new ActivityIntensityRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mActivityIntensityType, false);
        }
    }
}

