/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.MealType;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.BloodGlucose;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BloodGlucoseRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=25)
public class BloodGlucoseRecord
extends InstantRecord {
    private final int mSpecimenSource;
    private final BloodGlucose mLevel;
    private final int mRelationToMeal;
    private final int mMealType;

    private BloodGlucoseRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, int specimenSource, @NonNull BloodGlucose level, int relationToMeal, int mealType, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(level);
        if (!skipValidation) {
            ValidationUtils.requireInRange(level.getInMillimolesPerLiter(), 0.0, 50.0, "level");
        }
        ValidationUtils.validateIntDefValue(specimenSource, SpecimenSource.VALID_TYPES, SpecimenSource.class.getSimpleName());
        ValidationUtils.validateIntDefValue(relationToMeal, RelationToMealType.VALID_TYPES, RelationToMealType.class.getSimpleName());
        ValidationUtils.validateIntDefValue(mealType, MealType.VALID_TYPES, MealType.class.getSimpleName());
        this.mSpecimenSource = specimenSource;
        this.mLevel = level;
        this.mRelationToMeal = relationToMeal;
        this.mMealType = mealType;
    }

    public int getSpecimenSource() {
        return this.mSpecimenSource;
    }

    @NonNull
    public BloodGlucose getLevel() {
        return this.mLevel;
    }

    public int getRelationToMeal() {
        return this.mRelationToMeal;
    }

    public int getMealType() {
        return this.mMealType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        BloodGlucoseRecord that = (BloodGlucoseRecord)o;
        return this.getSpecimenSource() == that.getSpecimenSource() && this.getRelationToMeal() == that.getRelationToMeal() && this.getMealType() == that.getMealType() && Objects.equals(this.getLevel(), that.getLevel());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSpecimenSource(), this.getLevel(), this.getRelationToMeal(), this.getMealType());
    }

    public BloodGlucoseRecordInternal toRecordInternal() {
        BloodGlucoseRecordInternal recordInternal = (BloodGlucoseRecordInternal)new BloodGlucoseRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setSpecimenSource(this.mSpecimenSource);
        recordInternal.setLevel(this.mLevel.getInMillimolesPerLiter());
        recordInternal.setRelationToMeal(this.mRelationToMeal);
        recordInternal.setMealType(this.mMealType);
        return recordInternal;
    }

    public static class SpecimenSource {
        public static final int SPECIMEN_SOURCE_UNKNOWN = 0;
        public static final int SPECIMEN_SOURCE_INTERSTITIAL_FLUID = 1;
        public static final int SPECIMEN_SOURCE_CAPILLARY_BLOOD = 2;
        public static final int SPECIMEN_SOURCE_PLASMA = 3;
        public static final int SPECIMEN_SOURCE_SERUM = 4;
        public static final int SPECIMEN_SOURCE_TEARS = 5;
        public static final int SPECIMEN_SOURCE_WHOLE_BLOOD = 6;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6));

        private SpecimenSource() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SpecimenSourceType {
        }
    }

    public static class RelationToMealType {
        public static final int RELATION_TO_MEAL_UNKNOWN = 0;
        public static final int RELATION_TO_MEAL_GENERAL = 1;
        public static final int RELATION_TO_MEAL_FASTING = 2;
        public static final int RELATION_TO_MEAL_BEFORE_MEAL = 3;
        public static final int RELATION_TO_MEAL_AFTER_MEAL = 4;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));

        private RelationToMealType() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RelationToMealTypes {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mSpecimenSource;
        private final BloodGlucose mLevel;
        private final int mRelationToMeal;
        private final int mMealType;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, int specimenSource, @NonNull BloodGlucose level, int relationToMeal, int mealType) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(level);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mSpecimenSource = specimenSource;
            this.mLevel = level;
            this.mRelationToMeal = relationToMeal;
            this.mMealType = mealType;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public BloodGlucoseRecord buildWithoutValidation() {
            return new BloodGlucoseRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mSpecimenSource, this.mLevel, this.mRelationToMeal, this.mMealType, true);
        }

        @NonNull
        public BloodGlucoseRecord build() {
            return new BloodGlucoseRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mSpecimenSource, this.mLevel, this.mRelationToMeal, this.mMealType, false);
        }
    }
}

