/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.CervicalMucusRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=19)
public class CervicalMucusRecord
extends InstantRecord {
    private final int mSensation;
    private final int mAppearance;

    private CervicalMucusRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, int sensation, int appearance, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        ValidationUtils.validateIntDefValue(sensation, CervicalMucusSensation.VALID_TYPES, CervicalMucusSensation.class.getSimpleName());
        ValidationUtils.validateIntDefValue(appearance, CervicalMucusAppearance.VALID_TYPES, CervicalMucusAppearance.class.getSimpleName());
        this.mSensation = sensation;
        this.mAppearance = appearance;
    }

    public int getSensation() {
        return this.mSensation;
    }

    public int getAppearance() {
        return this.mAppearance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        CervicalMucusRecord that = (CervicalMucusRecord)o;
        return this.getSensation() == that.getSensation() && this.getAppearance() == that.getAppearance();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSensation(), this.getAppearance());
    }

    public CervicalMucusRecordInternal toRecordInternal() {
        CervicalMucusRecordInternal recordInternal = (CervicalMucusRecordInternal)new CervicalMucusRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setSensation(this.mSensation);
        recordInternal.setAppearance(this.mAppearance);
        return recordInternal;
    }

    public static class CervicalMucusSensation {
        public static final int SENSATION_UNKNOWN = 0;
        public static final int SENSATION_LIGHT = 1;
        public static final int SENSATION_MEDIUM = 2;
        public static final int SENSATION_HEAVY = 3;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));

        CervicalMucusSensation() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CervicalMucusSensations {
        }
    }

    public static class CervicalMucusAppearance {
        public static final int APPEARANCE_UNKNOWN = 0;
        public static final int APPEARANCE_DRY = 1;
        public static final int APPEARANCE_STICKY = 2;
        public static final int APPEARANCE_CREAMY = 3;
        public static final int APPEARANCE_WATERY = 4;
        public static final int APPEARANCE_EGG_WHITE = 5;
        public static final int APPEARANCE_UNUSUAL = 6;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6));

        CervicalMucusAppearance() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CervicalMucusAppearances {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mSensation;
        private final int mAppearance;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, int sensation, int appearance) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mSensation = sensation;
            this.mAppearance = appearance;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public CervicalMucusRecord buildWithoutValidation() {
            return new CervicalMucusRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mSensation, this.mAppearance, true);
        }

        @NonNull
        public CervicalMucusRecord build() {
            return new CervicalMucusRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mSensation, this.mAppearance, false);
        }
    }
}

