/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.validation.ValidationUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;

public class Device {
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int DEVICE_TYPE_WATCH = 1;
    public static final int DEVICE_TYPE_PHONE = 2;
    public static final int DEVICE_TYPE_SCALE = 3;
    public static final int DEVICE_TYPE_RING = 4;
    public static final int DEVICE_TYPE_HEAD_MOUNTED = 5;
    public static final int DEVICE_TYPE_FITNESS_BAND = 6;
    public static final int DEVICE_TYPE_CHEST_STRAP = 7;
    public static final int DEVICE_TYPE_SMART_DISPLAY = 8;
    private final String mManufacturer;
    private final String mModel;
    private final int mType;
    public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8));

    private Device(String manufacturer, String model, int type) {
        ValidationUtils.validateIntDefValue(type, VALID_TYPES, DeviceType.class.getSimpleName());
        this.mManufacturer = manufacturer;
        this.mModel = model;
        this.mType = type;
    }

    @Nullable
    public String getManufacturer() {
        return this.mManufacturer;
    }

    @Nullable
    public String getModel() {
        return this.mModel;
    }

    public int getType() {
        return this.mType;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Device) {
            Device other = (Device)object;
            return this.getType() == other.getType() && Objects.equals(this.getManufacturer(), other.getManufacturer()) && Objects.equals(this.getModel(), other.getModel());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getManufacturer(), this.getModel(), this.getType());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceType {
    }

    public static class Builder {
        private String mManufacturer;
        private String mModel;
        private int mType = 0;

        @NonNull
        public Builder setManufacturer(@Nullable String manufacturer) {
            this.mManufacturer = manufacturer;
            return this;
        }

        @NonNull
        public Builder setModel(@Nullable String model) {
            this.mModel = model;
            return this;
        }

        @NonNull
        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Device build() {
            return new Device(this.mManufacturer, this.mModel, this.mType);
        }
    }
}

