/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.units.Velocity;
import java.util.Objects;

@FlaggedApi(value="com.android.healthconnect.flags.training_plans")
public abstract class ExercisePerformanceGoal {
    private ExercisePerformanceGoal() {
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class UnknownGoal
    extends ExercisePerformanceGoal {
        @NonNull
        public static final UnknownGoal INSTANCE = new UnknownGoal();

        private UnknownGoal() {
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class AmrapGoal
    extends ExercisePerformanceGoal {
        @NonNull
        public static final AmrapGoal INSTANCE = new AmrapGoal();

        private AmrapGoal() {
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class RateOfPerceivedExertionGoal
    extends ExercisePerformanceGoal {
        private final int mRpe;

        public RateOfPerceivedExertionGoal(int rpe) {
            if (rpe < 0 || rpe > 10) {
                throw new IllegalArgumentException("RPE value must be between 0 and 10, inclusive.");
            }
            this.mRpe = rpe;
        }

        public int getRpe() {
            return this.mRpe;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RateOfPerceivedExertionGoal)) {
                return false;
            }
            RateOfPerceivedExertionGoal that = (RateOfPerceivedExertionGoal)o;
            return this.getRpe() == that.getRpe();
        }

        public int hashCode() {
            return Objects.hash(this.mRpe);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class WeightGoal
    extends ExercisePerformanceGoal {
        private final Mass mMass;

        public WeightGoal(@NonNull Mass mass) {
            Objects.requireNonNull(mass);
            this.mMass = mass;
        }

        @NonNull
        public Mass getMass() {
            return this.mMass;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeightGoal)) {
                return false;
            }
            WeightGoal that = (WeightGoal)o;
            return this.getMass().equals(that.getMass());
        }

        public int hashCode() {
            return Objects.hash(this.mMass);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class HeartRateGoal
    extends ExercisePerformanceGoal {
        private final int mMinBpm;
        private final int mMaxBpm;

        public HeartRateGoal(int minBpm, int maxBpm) {
            this.mMinBpm = minBpm;
            this.mMaxBpm = maxBpm;
        }

        public int getMinBpm() {
            return this.mMinBpm;
        }

        public int getMaxBpm() {
            return this.mMaxBpm;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeartRateGoal)) {
                return false;
            }
            HeartRateGoal that = (HeartRateGoal)o;
            return this.getMinBpm() == that.getMinBpm() && this.getMaxBpm() == that.getMaxBpm();
        }

        public int hashCode() {
            return Objects.hash(this.mMinBpm, this.mMaxBpm);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class CadenceGoal
    extends ExercisePerformanceGoal {
        private final double mMinRpm;
        private final double mMaxRpm;

        public CadenceGoal(double minRpm, double maxRpm) {
            this.mMinRpm = minRpm;
            this.mMaxRpm = maxRpm;
        }

        public double getMinRpm() {
            return this.mMinRpm;
        }

        public double getMaxRpm() {
            return this.mMaxRpm;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CadenceGoal)) {
                return false;
            }
            CadenceGoal that = (CadenceGoal)o;
            return this.getMinRpm() == that.getMinRpm() && this.getMaxRpm() == that.getMaxRpm();
        }

        public int hashCode() {
            return Objects.hash(this.mMinRpm, this.mMaxRpm);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class SpeedGoal
    extends ExercisePerformanceGoal {
        private final Velocity mMinSpeed;
        private final Velocity mMaxSpeed;

        public SpeedGoal(@NonNull Velocity minSpeed, @NonNull Velocity maxSpeed) {
            Objects.requireNonNull(minSpeed);
            Objects.requireNonNull(maxSpeed);
            this.mMinSpeed = minSpeed;
            this.mMaxSpeed = maxSpeed;
        }

        @NonNull
        public Velocity getMinSpeed() {
            return this.mMinSpeed;
        }

        @NonNull
        public Velocity getMaxSpeed() {
            return this.mMaxSpeed;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SpeedGoal)) {
                return false;
            }
            SpeedGoal that = (SpeedGoal)o;
            return this.getMinSpeed().equals(that.getMinSpeed()) && this.getMaxSpeed().equals(that.getMaxSpeed());
        }

        public int hashCode() {
            return Objects.hash(this.mMinSpeed, this.mMaxSpeed);
        }
    }

    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public static class PowerGoal
    extends ExercisePerformanceGoal {
        private final Power mMinPower;
        private final Power mMaxPower;

        public PowerGoal(@NonNull Power minPower, @NonNull Power maxPower) {
            Objects.requireNonNull(minPower);
            Objects.requireNonNull(maxPower);
            this.mMinPower = minPower;
            this.mMaxPower = maxPower;
        }

        @NonNull
        public Power getMinPower() {
            return this.mMinPower;
        }

        @NonNull
        public Power getMaxPower() {
            return this.mMaxPower;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PowerGoal)) {
                return false;
            }
            PowerGoal that = (PowerGoal)o;
            return this.getMinPower().equals(that.getMinPower()) && this.getMaxPower().equals(that.getMaxPower());
        }

        public int hashCode() {
            return Objects.hash(this.mMinPower, this.mMaxPower);
        }
    }
}

