/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class FhirVersion
implements Parcelable {
    private static final FhirVersion R4_FHIR_VERSION = FhirVersion.parseFhirVersion("4.0.1");
    private static final FhirVersion R4B_FHIR_VERSION = FhirVersion.parseFhirVersion("4.3.0");
    private static final Set<FhirVersion> SUPPORTED_FHIR_VERSIONS = Set.of(R4_FHIR_VERSION, R4B_FHIR_VERSION);
    private final int mMajor;
    private final int mMinor;
    private final int mPatch;
    private static final String VERSION_REGEX = "(\\d+)\\.(\\d+)\\.(\\d+)";
    @NonNull
    public static final Parcelable.Creator<FhirVersion> CREATOR = new Parcelable.Creator<FhirVersion>(){

        @Override
        public FhirVersion createFromParcel(Parcel in) {
            return new FhirVersion(in);
        }

        public FhirVersion[] newArray(int size) {
            return new FhirVersion[size];
        }
    };

    private FhirVersion(int major, int minor, int patch) {
        this.mMajor = major;
        this.mMinor = minor;
        this.mPatch = patch;
        this.validateVersionNumbersNotNegative();
    }

    private FhirVersion(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mMajor = in.readInt();
        this.mMinor = in.readInt();
        this.mPatch = in.readInt();
        this.validateVersionNumbersNotNegative();
    }

    @NonNull
    public static FhirVersion parseFhirVersion(@NonNull String fhirVersionString) {
        Objects.requireNonNull(fhirVersionString);
        Pattern pattern = Pattern.compile(VERSION_REGEX);
        Matcher matcher = pattern.matcher(fhirVersionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid FHIR version string: " + fhirVersionString);
        }
        return new FhirVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
    }

    public int getMajor() {
        return this.mMajor;
    }

    public int getMinor() {
        return this.mMinor;
    }

    public int getPatch() {
        return this.mPatch;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.getMajor());
        dest.writeInt(this.getMinor());
        dest.writeInt(this.getPatch());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FhirVersion)) {
            return false;
        }
        FhirVersion that = (FhirVersion)o;
        return this.getMajor() == that.getMajor() && this.getMinor() == that.getMinor() && this.getPatch() == that.getPatch();
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getPatch());
    }

    public String toString() {
        return String.format("%d.%d.%d", this.mMajor, this.mMinor, this.mPatch);
    }

    public boolean isSupportedFhirVersion() {
        return SUPPORTED_FHIR_VERSIONS.contains(this);
    }

    private void validateVersionNumbersNotNegative() {
        if (this.mMajor < 0 || this.mMinor < 0 || this.mPatch < 0) {
            throw new IllegalArgumentException("Version numbers can not be negative.");
        }
    }
}

