/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.Record;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

public abstract class InstantRecord
extends Record {
    private final Instant mTime;
    private final ZoneOffset mZoneOffset;

    InstantRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, boolean skipValidation) {
        super(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        if (!skipValidation && time.isAfter(Instant.now())) {
            throw new IllegalArgumentException("Record time must not be in the future, record time: " + time + " currentTime: " + Instant.now());
        }
        this.mTime = time;
        this.mZoneOffset = zoneOffset;
    }

    @NonNull
    public Instant getTime() {
        return this.mTime;
    }

    @NonNull
    public ZoneOffset getZoneOffset() {
        return this.mZoneOffset;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (super.equals(object)) {
            InstantRecord other = (InstantRecord)object;
            return this.getTime().toEpochMilli() == other.getTime().toEpochMilli() && ((Object)this.getZoneOffset()).equals(other.getZoneOffset());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTime(), this.getZoneOffset());
    }
}

