/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.MenstruationFlowRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=21)
public class MenstruationFlowRecord
extends InstantRecord {
    private final int mFlow;

    private MenstruationFlowRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, int flow, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        ValidationUtils.validateIntDefValue(flow, MenstruationFlowType.VALID_TYPES, MenstruationFlowType.class.getSimpleName());
        this.mFlow = flow;
    }

    public int getFlow() {
        return this.mFlow;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        MenstruationFlowRecord that = (MenstruationFlowRecord)o;
        return this.getFlow() == that.getFlow();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFlow());
    }

    public MenstruationFlowRecordInternal toRecordInternal() {
        MenstruationFlowRecordInternal recordInternal = (MenstruationFlowRecordInternal)new MenstruationFlowRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setFlow(this.mFlow);
        return recordInternal;
    }

    public static class MenstruationFlowType {
        public static final int FLOW_UNKNOWN = 0;
        public static final int FLOW_LIGHT = 1;
        public static final int FLOW_MEDIUM = 2;
        public static final int FLOW_HEAVY = 3;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));

        MenstruationFlowType() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface MenstruationFlowTypes {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mFlow;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, int flow) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mFlow = flow;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public MenstruationFlowRecord buildWithoutValidation() {
            return new MenstruationFlowRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mFlow, true);
        }

        @NonNull
        public MenstruationFlowRecord build() {
            return new MenstruationFlowRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mFlow, false);
        }
    }
}

