/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.PlannedExerciseStep;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.internal.datatypes.PlannedExerciseBlockInternal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@FlaggedApi(value="com.android.healthconnect.flags.training_plans")
public class PlannedExerciseBlock {
    private final int mRepetitions;
    @Nullable
    private final CharSequence mDescription;
    private final List<PlannedExerciseStep> mSteps;

    private PlannedExerciseBlock(int repetitions, @Nullable CharSequence description, @NonNull List<PlannedExerciseStep> steps) {
        this.mRepetitions = repetitions;
        this.mDescription = description;
        this.mSteps = steps;
    }

    @Nullable
    public CharSequence getDescription() {
        return this.mDescription;
    }

    @NonNull
    public List<PlannedExerciseStep> getSteps() {
        return this.mSteps;
    }

    public int getRepetitions() {
        return this.mRepetitions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlannedExerciseBlock)) {
            return false;
        }
        PlannedExerciseBlock that = (PlannedExerciseBlock)o;
        return RecordUtils.isEqualNullableCharSequences(this.getDescription(), that.getDescription()) && this.getRepetitions() == that.getRepetitions() && Objects.equals(this.getSteps(), that.getSteps());
    }

    public int hashCode() {
        return Objects.hash(this.getDescription(), this.getRepetitions(), this.getSteps());
    }

    public PlannedExerciseBlockInternal toInternalObject() {
        PlannedExerciseBlockInternal result = new PlannedExerciseBlockInternal(this.getRepetitions());
        if (this.mDescription != null) {
            result.setDescription(this.mDescription.toString());
        }
        result.setExerciseSteps(this.getSteps().stream().map(it -> it.toInternalObject()).collect(Collectors.toList()));
        return result;
    }

    public static class Builder {
        private int mRepetitions;
        private List<PlannedExerciseStep> mSteps = new ArrayList<PlannedExerciseStep>();
        @Nullable
        private CharSequence mDescription;

        public Builder(int repetitions) {
            this.mRepetitions = repetitions;
        }

        @NonNull
        public Builder setRepetitions(int repetitions) {
            this.mRepetitions = repetitions;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable CharSequence description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        public Builder addStep(@NonNull PlannedExerciseStep step) {
            Objects.requireNonNull(step);
            this.mSteps.add(step);
            return this;
        }

        @NonNull
        public Builder setSteps(@NonNull List<PlannedExerciseStep> steps) {
            Objects.requireNonNull(steps);
            this.mSteps.clear();
            this.mSteps.addAll(steps);
            return this;
        }

        @NonNull
        public Builder clearSteps() {
            this.mSteps.clear();
            return this;
        }

        @NonNull
        public PlannedExerciseBlock build() {
            return new PlannedExerciseBlock(this.mRepetitions, this.mDescription, List.copyOf(this.mSteps));
        }
    }
}

