/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.WeightRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=26)
public class WeightRecord
extends InstantRecord {
    private final Mass mWeight;
    @NonNull
    public static final AggregationType<Mass> WEIGHT_AVG = new AggregationType<Mass>(60, 2, 26, Mass.class);
    @NonNull
    public static final AggregationType<Mass> WEIGHT_MAX = new AggregationType<Mass>(61, 0, 26, Mass.class);
    @NonNull
    public static final AggregationType<Mass> WEIGHT_MIN = new AggregationType<Mass>(62, 1, 26, Mass.class);

    private WeightRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, @NonNull Mass weight, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(weight);
        if (!skipValidation) {
            ValidationUtils.requireInRange(weight.getInGrams(), 0.0, 1000000.0, "weight");
        }
        this.mWeight = weight;
    }

    @NonNull
    public Mass getWeight() {
        return this.mWeight;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        WeightRecord that = (WeightRecord)o;
        return this.getWeight().equals(that.getWeight());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getWeight());
    }

    public WeightRecordInternal toRecordInternal() {
        WeightRecordInternal recordInternal = (WeightRecordInternal)new WeightRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setWeight(this.mWeight.getInGrams());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final Mass mWeight;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, @NonNull Mass weight) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(weight);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mWeight = weight;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public WeightRecord buildWithoutValidation() {
            return new WeightRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mWeight, true);
        }

        @NonNull
        public WeightRecord build() {
            return new WeightRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mWeight, false);
        }
    }
}

