/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.exportimport;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;

public class ScheduledExportStatus
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<ScheduledExportStatus> CREATOR = new Parcelable.Creator<ScheduledExportStatus>(){

        @Override
        public ScheduledExportStatus createFromParcel(Parcel in) {
            return new ScheduledExportStatus(in);
        }

        public ScheduledExportStatus[] newArray(int size) {
            return new ScheduledExportStatus[size];
        }
    };
    public static final int DATA_EXPORT_ERROR_UNSPECIFIED = -1;
    public static final int DATA_EXPORT_ERROR_NONE = 0;
    public static final int DATA_EXPORT_ERROR_UNKNOWN = 1;
    public static final int DATA_EXPORT_LOST_FILE_ACCESS = 2;
    public static final int DATA_EXPORT_STARTED = 3;
    public static final int DATA_EXPORT_ERROR_CLEARING_LOG_TABLES = 4;
    public static final int DATA_EXPORT_ERROR_CLEARING_PHR_TABLES = 5;
    @Nullable
    private final Instant mLastSuccessfulExportTime;
    @Nullable
    private final Instant mLastFailedExportTime;
    private final int mDataExportError;
    private final int mPeriodInDays;
    @Nullable
    private final String mLastExportFileName;
    @Nullable
    private final String mLastExportAppName;
    @Nullable
    private final String mNextExportFileName;
    @Nullable
    private final String mNextExportAppName;
    private final int mNextExportSequentialNumber;

    private ScheduledExportStatus(@Nullable Instant lastSuccessfulExportTime, @Nullable Instant lastFailedExportTime, int dataExportError, int periodInDays, @Nullable String lastExportFileName, @Nullable String lastExportAppName, @Nullable String nextExportFileName, @Nullable String nextExportAppName, int nextExportSequentialNumber) {
        this.mLastSuccessfulExportTime = lastSuccessfulExportTime;
        this.mLastFailedExportTime = lastFailedExportTime;
        this.mDataExportError = dataExportError;
        this.mPeriodInDays = periodInDays;
        this.mLastExportFileName = lastExportFileName;
        this.mLastExportAppName = lastExportAppName;
        this.mNextExportFileName = nextExportFileName;
        this.mNextExportAppName = nextExportAppName;
        this.mNextExportSequentialNumber = nextExportSequentialNumber;
    }

    @Nullable
    public Instant getLastSuccessfulExportTime() {
        return this.mLastSuccessfulExportTime;
    }

    @Nullable
    public Instant getLastFailedExportTime() {
        return this.mLastFailedExportTime;
    }

    public int getDataExportError() {
        return this.mDataExportError;
    }

    public int getPeriodInDays() {
        return this.mPeriodInDays;
    }

    @Nullable
    public String getLastExportFileName() {
        return this.mLastExportFileName;
    }

    @Nullable
    public String getLastExportAppName() {
        return this.mLastExportAppName;
    }

    @Nullable
    public String getNextExportFileName() {
        return this.mNextExportFileName;
    }

    @Nullable
    public String getNextExportAppName() {
        return this.mNextExportAppName;
    }

    public int getNextExportSequentialNumber() {
        return this.mNextExportSequentialNumber;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private ScheduledExportStatus(@NonNull Parcel in) {
        long timestamp = in.readLong();
        this.mLastSuccessfulExportTime = timestamp == 0L ? null : Instant.ofEpochMilli(timestamp);
        long lastFailedExportTimestamp = in.readLong();
        this.mLastFailedExportTime = timestamp == 0L ? null : Instant.ofEpochMilli(lastFailedExportTimestamp);
        this.mDataExportError = in.readInt();
        this.mPeriodInDays = in.readInt();
        this.mLastExportFileName = in.readString();
        this.mLastExportAppName = in.readString();
        this.mNextExportFileName = in.readString();
        this.mNextExportAppName = in.readString();
        this.mNextExportSequentialNumber = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mLastSuccessfulExportTime == null ? 0L : this.mLastSuccessfulExportTime.toEpochMilli());
        dest.writeLong(this.mLastFailedExportTime == null ? 0L : this.mLastFailedExportTime.toEpochMilli());
        dest.writeInt(this.mDataExportError);
        dest.writeInt(this.mPeriodInDays);
        dest.writeString(this.mLastExportFileName);
        dest.writeString(this.mLastExportAppName);
        dest.writeString(this.mNextExportFileName);
        dest.writeString(this.mNextExportAppName);
        dest.writeInt(this.mNextExportSequentialNumber);
    }

    public static class Builder {
        @Nullable
        private Instant mLastSuccessfulExportTime;
        @Nullable
        private Instant mLastFailedExportTime;
        private int mDataExportError;
        private int mPeriodInDays;
        @Nullable
        private String mLastExportFileName;
        @Nullable
        private String mLastExportAppName;
        @Nullable
        private String mNextExportFileName;
        @Nullable
        private String mNextExportAppName;
        private int mNextExportSequentialNumber;

        public Builder setLastSuccessfulExportTime(@Nullable Instant lastSuccessfulExportTime) {
            this.mLastSuccessfulExportTime = lastSuccessfulExportTime;
            return this;
        }

        public Builder setLastFailedExportTime(@Nullable Instant lastFailedExportTime) {
            this.mLastFailedExportTime = lastFailedExportTime;
            return this;
        }

        public Builder setDataExportError(int dataExportError) {
            this.mDataExportError = dataExportError;
            return this;
        }

        public Builder setPeriodInDays(int periodInDays) {
            this.mPeriodInDays = periodInDays;
            return this;
        }

        public Builder setLastExportFileName(@Nullable String lastExportFileName) {
            this.mLastExportFileName = lastExportFileName;
            return this;
        }

        public Builder setLastExportAppName(@Nullable String lastExportAppName) {
            this.mLastExportAppName = lastExportAppName;
            return this;
        }

        public Builder setNextExportFileName(@Nullable String nextExportFileName) {
            this.mNextExportFileName = nextExportFileName;
            return this;
        }

        public Builder setNextExportAppName(@Nullable String nextExportAppName) {
            this.mNextExportAppName = nextExportAppName;
            return this;
        }

        public Builder setNextExportSequentialNumber(int nextExportSequentialNumber) {
            this.mNextExportSequentialNumber = nextExportSequentialNumber;
            return this;
        }

        public ScheduledExportStatus build() {
            return new ScheduledExportStatus(this.mLastSuccessfulExportTime, this.mLastFailedExportTime, this.mDataExportError, this.mPeriodInDays, this.mLastExportFileName, this.mLastExportAppName, this.mNextExportFileName, this.mNextExportAppName, this.mNextExportSequentialNumber);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataExportError {
    }
}

