/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.StepsCadenceRecord;
import android.health.connect.internal.datatypes.SeriesRecordInternal;
import android.os.Parcel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=15)
public class StepsCadenceRecordInternal
extends SeriesRecordInternal<StepsCadenceRecord, StepsCadenceRecord.StepsCadenceRecordSample> {
    private Set<StepsCadenceRecordSample> mStepsCadenceRecordSamples;

    @Override
    @NonNull
    public Set<StepsCadenceRecordSample> getSamples() {
        return this.mStepsCadenceRecordSamples;
    }

    @Override
    @NonNull
    public StepsCadenceRecordInternal setSamples(Set<? extends SeriesRecordInternal.Sample> samples) {
        Objects.requireNonNull(samples);
        this.mStepsCadenceRecordSamples = samples;
        return this;
    }

    @Override
    @NonNull
    public StepsCadenceRecord toExternalRecord() {
        return new StepsCadenceRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExternalSamples()).setStartZoneOffset(this.getStartZoneOffset()).setEndZoneOffset(this.getEndZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateIntervalRecordFrom(@NonNull Parcel parcel) {
        int size = parcel.readInt();
        this.mStepsCadenceRecordSamples = new HashSet<StepsCadenceRecordSample>(size);
        for (int i = 0; i < size; ++i) {
            this.mStepsCadenceRecordSamples.add(new StepsCadenceRecordSample(parcel.readDouble(), parcel.readLong()));
        }
    }

    private List<StepsCadenceRecord.StepsCadenceRecordSample> getExternalSamples() {
        ArrayList<StepsCadenceRecord.StepsCadenceRecordSample> stepsCadenceRecords = new ArrayList<StepsCadenceRecord.StepsCadenceRecordSample>(this.mStepsCadenceRecordSamples.size());
        for (StepsCadenceRecordSample stepsCadenceRecordSample : this.mStepsCadenceRecordSamples) {
            stepsCadenceRecords.add(new StepsCadenceRecord.StepsCadenceRecordSample(stepsCadenceRecordSample.getRate(), Instant.ofEpochMilli(stepsCadenceRecordSample.getEpochMillis()), true));
        }
        return stepsCadenceRecords;
    }

    @Override
    void populateIntervalRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mStepsCadenceRecordSamples.size());
        for (StepsCadenceRecordSample stepsCadenceRecordSample : this.mStepsCadenceRecordSamples) {
            parcel.writeDouble(stepsCadenceRecordSample.getRate());
            parcel.writeLong(stepsCadenceRecordSample.getEpochMillis());
        }
    }

    public static class StepsCadenceRecordSample
    implements SeriesRecordInternal.Sample {
        private final double mRate;
        private final long mEpochMillis;

        public StepsCadenceRecordSample(double rate, long epochMillis) {
            this.mRate = rate;
            this.mEpochMillis = epochMillis;
        }

        public double getRate() {
            return this.mRate;
        }

        public long getEpochMillis() {
            return this.mEpochMillis;
        }

        public boolean equals(@Nullable Object object) {
            if (super.equals(object) && object instanceof StepsCadenceRecordSample) {
                StepsCadenceRecordSample other = (StepsCadenceRecordSample)object;
                return this.getEpochMillis() == other.getEpochMillis();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getEpochMillis());
        }
    }
}

