/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.annotation.NonNull;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.RecordInternal;
import android.health.connect.internal.datatypes.utils.HealthConnectMappings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InternalExternalRecordConverter {
    private static volatile InternalExternalRecordConverter sInternalExternalRecordConverter;
    private final Map<Integer, Class<? extends RecordInternal<?>>> mRecordIdToInternalRecordClassMap = HealthConnectMappings.getInstance().getRecordIdToInternalRecordClassMap();

    private InternalExternalRecordConverter() {
    }

    @NonNull
    public static synchronized InternalExternalRecordConverter getInstance() {
        if (sInternalExternalRecordConverter == null) {
            sInternalExternalRecordConverter = new InternalExternalRecordConverter();
        }
        return sInternalExternalRecordConverter;
    }

    @NonNull
    public RecordInternal<?> newInternalRecord(int type) {
        RecordInternal<?> recordInternal;
        Class<RecordInternal<?>> recordClass = this.mRecordIdToInternalRecordClassMap.get(type);
        Objects.requireNonNull(recordClass);
        try {
            recordInternal = recordClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return recordInternal;
    }

    @NonNull
    public List<Record> getExternalRecords(@NonNull List<RecordInternal<?>> recordInternals) {
        ArrayList<Record> externalRecordList = new ArrayList<Record>(recordInternals.size());
        for (RecordInternal<?> recordInternal : recordInternals) {
            try {
                externalRecordList.add((Record)recordInternal.toExternalRecord());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getMessage().contains("Unknown Intdef value")) continue;
                throw illegalArgumentException;
            }
        }
        return externalRecordList;
    }
}

