/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice.navigationbar;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.NonNull;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.inputmethodservice.navigationbar.ButtonDispatcher;
import android.inputmethodservice.navigationbar.DeadZone;
import android.inputmethodservice.navigationbar.KeyButtonDrawable;
import android.inputmethodservice.navigationbar.NavigationBarFrame;
import android.inputmethodservice.navigationbar.NavigationBarInflaterView;
import android.inputmethodservice.navigationbar.NavigationBarUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.view.inputmethod.Flags;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import java.util.function.Consumer;

public class NavigationBarView
extends FrameLayout {
    private static final boolean DEBUG = false;
    private static final String TAG = "NavBarView";
    private static final Interpolator FAST_OUT_SLOW_IN = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    View mCurrentView = null;
    private View mHorizontal;
    private int mCurrentRotation = -1;
    int mDisabledFlags = 0;
    private int mNavbarFlags;
    private final int mNavBarMode = 2;
    private KeyButtonDrawable mBackIcon;
    private KeyButtonDrawable mImeSwitcherIcon;
    private Context mLightContext;
    private final int mLightIconColor;
    private final int mDarkIconColor;
    private final DeadZone mDeadZone;
    private boolean mDeadZoneConsuming = false;
    private final SparseArray<ButtonDispatcher> mButtonDispatchers = new SparseArray();
    private Configuration mConfiguration;
    private Configuration mTmpLastConfiguration;
    private NavigationBarInflaterView mNavigationInflaterView;

    public NavigationBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mLightContext = context;
        this.mLightIconColor = -1;
        this.mDarkIconColor = -1728053248;
        this.mConfiguration = new Configuration();
        this.mTmpLastConfiguration = new Configuration();
        this.mConfiguration.updateFrom(context.getResources().getConfiguration());
        this.mButtonDispatchers.put(16909188, new ButtonDispatcher(16909188));
        this.mButtonDispatchers.put(16909194, new ButtonDispatcher(16909194));
        this.mButtonDispatchers.put(16909192, new ButtonDispatcher(16909192));
        this.mDeadZone = new DeadZone(this);
    }

    public void prepareNavButtons(@NonNull ButtonClickListener listener) {
        this.getBackButton().setLongClickable(false);
        if (Flags.imeSwitcherRevamp()) {
            ButtonDispatcher imeSwitchButton = this.getImeSwitchButton();
            imeSwitchButton.setLongClickable(true);
            imeSwitchButton.setOnClickListener(listener::onImeSwitchButtonClick);
            imeSwitchButton.setOnLongClickListener(listener::onImeSwitchButtonLongClick);
        } else {
            ButtonDispatcher imeSwitchButton = this.getImeSwitchButton();
            imeSwitchButton.setLongClickable(false);
            imeSwitchButton.setOnClickListener(view -> view.getContext().getSystemService(InputMethodManager.class).showInputMethodPicker());
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.shouldDeadZoneConsumeTouchEvents(event) || super.onInterceptTouchEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        this.shouldDeadZoneConsumeTouchEvents(event);
        return super.onTouchEvent(event);
    }

    private boolean shouldDeadZoneConsumeTouchEvents(MotionEvent event) {
        int action = event.getActionMasked();
        if (action == 0) {
            this.mDeadZoneConsuming = false;
        }
        if (this.mDeadZone.onTouchEvent(event) || this.mDeadZoneConsuming) {
            switch (action) {
                case 0: {
                    this.mDeadZoneConsuming = true;
                    break;
                }
                case 1: 
                case 3: {
                    this.mDeadZoneConsuming = false;
                }
            }
            return true;
        }
        return false;
    }

    public View getCurrentView() {
        return this.mCurrentView;
    }

    public void forEachView(Consumer<View> consumer) {
        if (this.mHorizontal != null) {
            consumer.accept(this.mHorizontal);
        }
    }

    public ButtonDispatcher getBackButton() {
        return this.mButtonDispatchers.get(16909188);
    }

    public ButtonDispatcher getImeSwitchButton() {
        return this.mButtonDispatchers.get(16909194);
    }

    public ButtonDispatcher getHomeHandle() {
        return this.mButtonDispatchers.get(16909192);
    }

    public SparseArray<ButtonDispatcher> getButtonDispatchers() {
        return this.mButtonDispatchers;
    }

    private void reloadNavIcons() {
        this.updateIcons(Configuration.EMPTY);
    }

    private void updateIcons(Configuration oldConfig) {
        boolean dirChange;
        boolean orientationChange = oldConfig.orientation != this.mConfiguration.orientation;
        boolean densityChange = oldConfig.densityDpi != this.mConfiguration.densityDpi;
        boolean bl = dirChange = oldConfig.getLayoutDirection() != this.mConfiguration.getLayoutDirection();
        if (densityChange || dirChange) {
            int switcherResId = Flags.imeSwitcherRevamp() ? 17302606 : 17302605;
            this.mImeSwitcherIcon = this.getDrawable(switcherResId);
        }
        if (orientationChange || densityChange || dirChange) {
            this.mBackIcon = this.getBackDrawable();
        }
    }

    private KeyButtonDrawable getBackDrawable() {
        KeyButtonDrawable drawable2 = this.getDrawable(17302604);
        this.orientBackButton(drawable2);
        return drawable2;
    }

    public static boolean isGesturalMode(int mode) {
        return mode == 2;
    }

    private void orientBackButton(KeyButtonDrawable drawable2) {
        float degrees;
        boolean isRtl;
        boolean isBackDismissIme = (this.mNavbarFlags & 1) != 0;
        boolean bl = isRtl = this.mConfiguration.getLayoutDirection() == 1;
        float f = isBackDismissIme ? (float)(isRtl ? 90 : -90) : (degrees = 0.0f);
        if (drawable2.getRotation() == degrees) {
            return;
        }
        if (NavigationBarView.isGesturalMode(2)) {
            drawable2.setRotation(degrees);
            return;
        }
        float targetY = isBackDismissIme ? (float)(-NavigationBarUtils.dpToPx(2.0f, this.getResources())) : 0.0f;
        ObjectAnimator navBarAnimator = ObjectAnimator.ofPropertyValuesHolder(drawable2, PropertyValuesHolder.ofFloat(KeyButtonDrawable.KEY_DRAWABLE_ROTATE, degrees), PropertyValuesHolder.ofFloat(KeyButtonDrawable.KEY_DRAWABLE_TRANSLATE_Y, targetY));
        navBarAnimator.setInterpolator(FAST_OUT_SLOW_IN);
        navBarAnimator.setDuration(200L);
        navBarAnimator.start();
    }

    private KeyButtonDrawable getDrawable(int icon) {
        return KeyButtonDrawable.create(this.mLightContext, this.mLightIconColor, this.mDarkIconColor, icon, true, null);
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        this.reloadNavIcons();
        super.setLayoutDirection(layoutDirection);
    }

    public void setNavbarFlags(int flags) {
        boolean oldBackDismissIme;
        if (flags == this.mNavbarFlags) {
            return;
        }
        boolean backDismissIme = (flags & 1) != 0;
        boolean bl = oldBackDismissIme = (this.mNavbarFlags & 1) != 0;
        if (backDismissIme != oldBackDismissIme) {
            // empty if block
        }
        this.mNavbarFlags = flags;
        this.updateNavButtonIcons();
    }

    private void updateNavButtonIcons() {
        KeyButtonDrawable backIcon = this.mBackIcon;
        this.orientBackButton(backIcon);
        this.getBackButton().setImageDrawable(backIcon);
        this.getImeSwitchButton().setImageDrawable(this.mImeSwitcherIcon);
        boolean isImeSwitcherButtonVisible = (this.mNavbarFlags & 4) != 0;
        this.getImeSwitchButton().setVisibility(isImeSwitcherButtonVisible ? 0 : 4);
        this.getBackButton().setVisibility(0);
        this.getHomeHandle().setVisibility(4);
    }

    private Display getContextDisplay() {
        return this.getContext().getDisplay();
    }

    @Override
    public void onFinishInflate() {
        super.onFinishInflate();
        this.mNavigationInflaterView = (NavigationBarInflaterView)this.findViewById(16909195);
        this.mNavigationInflaterView.setButtonDispatchers(this.mButtonDispatchers);
        this.updateOrientationViews();
        this.reloadNavIcons();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.mDeadZone.onDraw(canvas);
        super.onDraw(canvas);
    }

    private void updateOrientationViews() {
        this.mHorizontal = this.findViewById(16909193);
        this.updateCurrentView();
    }

    private void updateCurrentView() {
        this.resetViews();
        this.mCurrentView = this.mHorizontal;
        this.mCurrentView.setVisibility(0);
        this.mCurrentRotation = this.getContextDisplay().getRotation();
        this.mNavigationInflaterView.setAlternativeOrder(this.mCurrentRotation == 1);
        this.mNavigationInflaterView.updateButtonDispatchersCurrentView();
    }

    private void resetViews() {
        this.mHorizontal.setVisibility(8);
    }

    private void reorient() {
        this.updateCurrentView();
        NavigationBarFrame frame = (NavigationBarFrame)this.getRootView().findViewByPredicate(view -> view instanceof NavigationBarFrame);
        frame.setDeadZone(this.mDeadZone);
        this.mDeadZone.onConfigurationChanged(this.mCurrentRotation);
        if (!this.isLayoutDirectionResolved()) {
            this.resolveLayoutDirection();
        }
        this.updateNavButtonIcons();
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mTmpLastConfiguration.updateFrom(this.mConfiguration);
        int changes = this.mConfiguration.updateFrom(newConfig);
        this.updateIcons(this.mTmpLastConfiguration);
        if (this.mTmpLastConfiguration.densityDpi != this.mConfiguration.densityDpi || this.mTmpLastConfiguration.getLayoutDirection() != this.mConfiguration.getLayoutDirection()) {
            this.updateNavButtonIcons();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestApplyInsets();
        this.reorient();
        this.updateNavButtonIcons();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        for (int i = 0; i < this.mButtonDispatchers.size(); ++i) {
            this.mButtonDispatchers.valueAt(i).onDestroy();
        }
    }

    public void setDarkIntensity(float intensity) {
        for (int i = 0; i < this.mButtonDispatchers.size(); ++i) {
            this.mButtonDispatchers.valueAt(i).setDarkIntensity(intensity);
        }
    }

    public static interface ButtonClickListener {
        public void onImeSwitchButtonClick(View var1);

        public boolean onImeSwitchButtonLongClick(View var1);
    }
}

