/*
 * Decompiled with CFR 0.152.
 */
package android.internal.aconfig.storage;

public class AconfigStorageException
extends RuntimeException {
    public static final int ERROR_GENERIC = 0;
    public static final int ERROR_STORAGE_SYSTEM_NOT_FOUND = 1;
    public static final int ERROR_PACKAGE_NOT_FOUND = 2;
    public static final int ERROR_CONTAINER_NOT_FOUND = 3;
    public static final int ERROR_CANNOT_READ_STORAGE_FILE = 4;
    public static final int ERROR_FILE_FINGERPRINT_MISMATCH = 5;
    private final int mErrorCode;

    public AconfigStorageException(String msg) {
        super(msg);
        this.mErrorCode = 0;
    }

    public AconfigStorageException(String msg, Throwable cause) {
        super(msg, cause);
        this.mErrorCode = 0;
    }

    public AconfigStorageException(int errorCode, String msg) {
        super(msg);
        this.mErrorCode = errorCode;
    }

    public AconfigStorageException(int errorCode, String msg, Throwable cause) {
        super(msg, cause);
        this.mErrorCode = errorCode;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    public String getMessage() {
        return this.errorString() + ": " + super.getMessage();
    }

    private String errorString() {
        switch (this.mErrorCode) {
            case 0: {
                return "ERROR_GENERIC";
            }
            case 1: {
                return "ERROR_STORAGE_SYSTEM_NOT_FOUND";
            }
            case 2: {
                return "ERROR_PACKAGE_NOT_FOUND";
            }
            case 3: {
                return "ERROR_CONTAINER_NOT_FOUND";
            }
            case 4: {
                return "ERROR_CANNOT_READ_STORAGE_FILE";
            }
            case 5: {
                return "ERROR_FILE_FINGERPRINT_MISMATCH";
            }
        }
        return "<Unknown error code " + this.mErrorCode + ">";
    }
}

