/*
 * Decompiled with CFR 0.152.
 */
package android.internal.aconfig.storage;

import android.internal.aconfig.storage.AconfigStorageException;
import android.internal.aconfig.storage.ByteBufferReader;
import android.internal.aconfig.storage.FileType;
import android.internal.aconfig.storage.FlagType;
import android.internal.aconfig.storage.TableUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class FlagTable {
    private Header mHeader;
    private ByteBuffer mBuffer;

    public static FlagTable fromBytes(ByteBuffer bytes) {
        FlagTable flagTable = new FlagTable();
        flagTable.mBuffer = bytes;
        flagTable.mHeader = Header.fromBytes(new ByteBufferReader(bytes));
        return flagTable;
    }

    public Node get(int packageId, String flagName) {
        int numBuckets = (this.mHeader.mNodeOffset - this.mHeader.mBucketOffset) / 4;
        int bucketIndex = TableUtils.getBucketIndex(FlagTable.makeKey(packageId, flagName), numBuckets);
        int newPosition = this.mHeader.mBucketOffset + bucketIndex * 4;
        if (newPosition >= this.mHeader.mNodeOffset) {
            return null;
        }
        ByteBufferReader reader = new ByteBufferReader(this.mBuffer);
        reader.position(newPosition);
        int nodeIndex = reader.readInt();
        if (nodeIndex < this.mHeader.mNodeOffset || nodeIndex >= this.mHeader.mFileSize) {
            return null;
        }
        while (nodeIndex != -1) {
            reader.position(nodeIndex);
            Node node = Node.fromBytes(reader);
            if (Objects.equals(flagName, node.mFlagName) && packageId == node.mPackageId) {
                return node;
            }
            nodeIndex = node.mNextOffset;
        }
        return null;
    }

    public Header getHeader() {
        return this.mHeader;
    }

    private static byte[] makeKey(int packageId, String flagName) {
        StringBuilder ret = new StringBuilder();
        return ret.append(packageId).append('/').append(flagName).toString().getBytes(StandardCharsets.UTF_8);
    }

    public static class Header {
        private int mVersion;
        private String mContainer;
        private FileType mFileType;
        private int mFileSize;
        private int mNumFlags;
        private int mBucketOffset;
        private int mNodeOffset;

        public static Header fromBytes(ByteBufferReader reader) {
            Header header = new Header();
            header.mVersion = reader.readInt();
            header.mContainer = reader.readString();
            header.mFileType = FileType.fromInt(reader.readByte());
            header.mFileSize = reader.readInt();
            header.mNumFlags = reader.readInt();
            header.mBucketOffset = reader.readInt();
            header.mNodeOffset = reader.readInt();
            if (header.mFileType != FileType.FLAG_MAP) {
                throw new AconfigStorageException("binary file is not a flag map");
            }
            return header;
        }

        public int getVersion() {
            return this.mVersion;
        }

        public String getContainer() {
            return this.mContainer;
        }

        public FileType getFileType() {
            return this.mFileType;
        }

        public int getFileSize() {
            return this.mFileSize;
        }

        public int getNumFlags() {
            return this.mNumFlags;
        }

        public int getBucketOffset() {
            return this.mBucketOffset;
        }

        public int getNodeOffset() {
            return this.mNodeOffset;
        }
    }

    public static class Node {
        private String mFlagName;
        private FlagType mFlagType;
        private int mPackageId;
        private int mFlagIndex;
        private int mNextOffset;

        public static Node fromBytes(ByteBufferReader reader) {
            Node node = new Node();
            node.mPackageId = reader.readInt();
            node.mFlagName = reader.readString();
            node.mFlagType = FlagType.fromInt(reader.readShort());
            node.mFlagIndex = reader.readShort();
            node.mNextOffset = reader.readInt();
            node.mNextOffset = node.mNextOffset == 0 ? -1 : node.mNextOffset;
            return node;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mFlagName, this.mFlagType, this.mPackageId, this.mFlagIndex, this.mNextOffset});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            return Objects.equals(this.mFlagName, other.mFlagName) && Objects.equals((Object)this.mFlagType, (Object)other.mFlagType) && this.mPackageId == other.mPackageId && this.mFlagIndex == other.mFlagIndex && this.mNextOffset == other.mNextOffset;
        }

        public String getFlagName() {
            return this.mFlagName;
        }

        public FlagType getFlagType() {
            return this.mFlagType;
        }

        public int getPackageId() {
            return this.mPackageId;
        }

        public int getFlagIndex() {
            return this.mFlagIndex;
        }

        public int getNextOffset() {
            return this.mNextOffset;
        }
    }
}

