/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class AudioDescriptor
implements Parcelable {
    public static final int STANDARD_NONE = 0;
    public static final int STANDARD_EDID = 1;
    public static final int STANDARD_SADB = 2;
    public static final int STANDARD_VSADB = 3;
    private final int mStandard;
    private final byte[] mDescriptor;
    private final int mEncapsulationType;
    @NonNull
    public static final Parcelable.Creator<AudioDescriptor> CREATOR = new Parcelable.Creator<AudioDescriptor>(){

        @Override
        public AudioDescriptor createFromParcel(Parcel p) {
            return new AudioDescriptor(p);
        }

        public AudioDescriptor[] newArray(int size) {
            return new AudioDescriptor[size];
        }
    };

    @SystemApi
    public AudioDescriptor(int standard, int encapsulationType, @NonNull byte[] descriptor) {
        this.mStandard = standard;
        this.mEncapsulationType = encapsulationType;
        this.mDescriptor = descriptor;
    }

    public int getStandard() {
        return this.mStandard;
    }

    @NonNull
    public byte[] getDescriptor() {
        return this.mDescriptor;
    }

    public int getEncapsulationType() {
        return this.mEncapsulationType;
    }

    public int hashCode() {
        return Objects.hash(this.mStandard, this.mEncapsulationType, Arrays.hashCode(this.mDescriptor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioDescriptor that = (AudioDescriptor)o;
        return this.mStandard == that.mStandard && this.mEncapsulationType == that.mEncapsulationType && Arrays.equals(this.mDescriptor, that.mDescriptor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("standard=" + this.mStandard);
        sb.append(", encapsulation type=" + this.mEncapsulationType);
        if (this.mDescriptor != null && this.mDescriptor.length > 0) {
            sb.append(", descriptor=").append(Arrays.toString(this.mDescriptor));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStandard);
        dest.writeInt(this.mEncapsulationType);
        dest.writeByteArray(this.mDescriptor);
    }

    private AudioDescriptor(@NonNull Parcel in) {
        this.mStandard = in.readInt();
        this.mEncapsulationType = in.readInt();
        this.mDescriptor = in.createByteArray();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioDescriptorStandard {
    }
}

