/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDeviceAttributes;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IStrategyNonDefaultDevicesDispatcher
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IStrategyNonDefaultDevicesDispatcher";

    public void dispatchNonDefDevicesChanged(int var1, List<AudioDeviceAttributes> var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStrategyNonDefaultDevicesDispatcher {
        static final int TRANSACTION_dispatchNonDefDevicesChanged = 1;

        public Stub() {
            this.attachInterface(this, IStrategyNonDefaultDevicesDispatcher.DESCRIPTOR);
        }

        public static IStrategyNonDefaultDevicesDispatcher asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IStrategyNonDefaultDevicesDispatcher.DESCRIPTOR);
            if (iin != null && iin instanceof IStrategyNonDefaultDevicesDispatcher) {
                return (IStrategyNonDefaultDevicesDispatcher)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dispatchNonDefDevicesChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IStrategyNonDefaultDevicesDispatcher.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ArrayList<AudioDeviceAttributes> _arg1 = data.createTypedArrayList(AudioDeviceAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchNonDefDevicesChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IStrategyNonDefaultDevicesDispatcher {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IStrategyNonDefaultDevicesDispatcher.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchNonDefDevicesChanged(int strategyId, List<AudioDeviceAttributes> devices) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStrategyNonDefaultDevicesDispatcher.DESCRIPTOR);
                    _data.writeInt(strategyId);
                    _data.writeTypedList(devices, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStrategyNonDefaultDevicesDispatcher {
        @Override
        public void dispatchNonDefDevicesChanged(int strategyId, List<AudioDeviceAttributes> devices) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

