/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class AdResponse
implements Parcelable {
    public static final int RESPONSE_TYPE_PLAYING = 1;
    public static final int RESPONSE_TYPE_FINISHED = 2;
    public static final int RESPONSE_TYPE_STOPPED = 3;
    public static final int RESPONSE_TYPE_ERROR = 4;
    public static final int RESPONSE_TYPE_BUFFERING = 5;
    @NonNull
    public static final Parcelable.Creator<AdResponse> CREATOR = new Parcelable.Creator<AdResponse>(){

        @Override
        public AdResponse createFromParcel(Parcel source) {
            return new AdResponse(source);
        }

        public AdResponse[] newArray(int size) {
            return new AdResponse[size];
        }
    };
    private final int mId;
    private final int mResponseType;
    private final long mElapsedTime;

    public AdResponse(int id2, int responseType, long elapsedTime) {
        this.mId = id2;
        this.mResponseType = responseType;
        this.mElapsedTime = elapsedTime;
    }

    private AdResponse(Parcel source) {
        this.mId = source.readInt();
        this.mResponseType = source.readInt();
        this.mElapsedTime = source.readLong();
    }

    public int getId() {
        return this.mId;
    }

    public int getResponseType() {
        return this.mResponseType;
    }

    public long getElapsedTimeMillis() {
        return this.mElapsedTime;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mResponseType);
        dest.writeLong(this.mElapsedTime);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResponseType {
    }
}

