/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.INetworkPolicyListener;
import android.net.Network;
import android.net.NetworkPolicy;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.telephony.SubscriptionPlan;

public interface INetworkPolicyManager
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkPolicyManager.aidl:34:1:34:25")
    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public void setUidPolicy(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public void addUidPolicy(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public void removeUidPolicy(int var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkPolicyManager.aidl:41:1:41:25")
    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public int getUidPolicy(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public int[] getUidsWithPolicy(int var1) throws RemoteException;

    public void registerListener(INetworkPolicyListener var1) throws RemoteException;

    public void unregisterListener(INetworkPolicyListener var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkPolicyManager.aidl:51:1:51:25")
    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public void setNetworkPolicies(NetworkPolicy[] var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public NetworkPolicy[] getNetworkPolicies(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkPolicyManager.aidl:58:1:58:25")
    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public void snoozeLimit(NetworkTemplate var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkPolicyManager.aidl:62:1:62:25")
    public void setRestrictBackground(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/net/INetworkPolicyManager.aidl:65:1:65:25")
    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public boolean getRestrictBackground() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_NETWORK_STATE")
    public int getRestrictBackgroundByCaller() throws RemoteException;

    public int getRestrictBackgroundStatus(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public void setDeviceIdleMode(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_NETWORK_POLICY")
    public void setWifiMeteredOverride(String var1, int var2) throws RemoteException;

    public int getMultipathPreference(Network var1) throws RemoteException;

    public SubscriptionPlan getSubscriptionPlan(NetworkTemplate var1) throws RemoteException;

    public void notifyStatsProviderWarningOrLimitReached() throws RemoteException;

    public SubscriptionPlan[] getSubscriptionPlans(int var1, String var2) throws RemoteException;

    public void setSubscriptionPlans(int var1, SubscriptionPlan[] var2, long var3, String var5) throws RemoteException;

    public String getSubscriptionPlansOwner(int var1) throws RemoteException;

    public void setSubscriptionOverride(int var1, int var2, int var3, int[] var4, long var5, String var7) throws RemoteException;

    @EnforcePermission(value="android.permission.NETWORK_SETTINGS")
    public void factoryReset(String var1) throws RemoteException;

    public boolean isUidNetworkingBlocked(int var1, boolean var2) throws RemoteException;

    @EnforcePermission(value="android.permission.OBSERVE_NETWORK_POLICY")
    public boolean isUidRestrictedOnMeteredNetworks(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkPolicyManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.net.INetworkPolicyManager";
        static final int TRANSACTION_setUidPolicy = 1;
        static final int TRANSACTION_addUidPolicy = 2;
        static final int TRANSACTION_removeUidPolicy = 3;
        static final int TRANSACTION_getUidPolicy = 4;
        static final int TRANSACTION_getUidsWithPolicy = 5;
        static final int TRANSACTION_registerListener = 6;
        static final int TRANSACTION_unregisterListener = 7;
        static final int TRANSACTION_setNetworkPolicies = 8;
        static final int TRANSACTION_getNetworkPolicies = 9;
        static final int TRANSACTION_snoozeLimit = 10;
        static final int TRANSACTION_setRestrictBackground = 11;
        static final int TRANSACTION_getRestrictBackground = 12;
        static final int TRANSACTION_getRestrictBackgroundByCaller = 13;
        static final int TRANSACTION_getRestrictBackgroundStatus = 14;
        static final int TRANSACTION_setDeviceIdleMode = 15;
        static final int TRANSACTION_setWifiMeteredOverride = 16;
        static final int TRANSACTION_getMultipathPreference = 17;
        static final int TRANSACTION_getSubscriptionPlan = 18;
        static final int TRANSACTION_notifyStatsProviderWarningOrLimitReached = 19;
        static final int TRANSACTION_getSubscriptionPlans = 20;
        static final int TRANSACTION_setSubscriptionPlans = 21;
        static final int TRANSACTION_getSubscriptionPlansOwner = 22;
        static final int TRANSACTION_setSubscriptionOverride = 23;
        static final int TRANSACTION_factoryReset = 24;
        static final int TRANSACTION_isUidNetworkingBlocked = 25;
        static final int TRANSACTION_isUidRestrictedOnMeteredNetworks = 26;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static INetworkPolicyManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkPolicyManager) {
                return (INetworkPolicyManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setUidPolicy";
                }
                case 2: {
                    return "addUidPolicy";
                }
                case 3: {
                    return "removeUidPolicy";
                }
                case 4: {
                    return "getUidPolicy";
                }
                case 5: {
                    return "getUidsWithPolicy";
                }
                case 6: {
                    return "registerListener";
                }
                case 7: {
                    return "unregisterListener";
                }
                case 8: {
                    return "setNetworkPolicies";
                }
                case 9: {
                    return "getNetworkPolicies";
                }
                case 10: {
                    return "snoozeLimit";
                }
                case 11: {
                    return "setRestrictBackground";
                }
                case 12: {
                    return "getRestrictBackground";
                }
                case 13: {
                    return "getRestrictBackgroundByCaller";
                }
                case 14: {
                    return "getRestrictBackgroundStatus";
                }
                case 15: {
                    return "setDeviceIdleMode";
                }
                case 16: {
                    return "setWifiMeteredOverride";
                }
                case 17: {
                    return "getMultipathPreference";
                }
                case 18: {
                    return "getSubscriptionPlan";
                }
                case 19: {
                    return "notifyStatsProviderWarningOrLimitReached";
                }
                case 20: {
                    return "getSubscriptionPlans";
                }
                case 21: {
                    return "setSubscriptionPlans";
                }
                case 22: {
                    return "getSubscriptionPlansOwner";
                }
                case 23: {
                    return "setSubscriptionOverride";
                }
                case 24: {
                    return "factoryReset";
                }
                case 25: {
                    return "isUidNetworkingBlocked";
                }
                case 26: {
                    return "isUidRestrictedOnMeteredNetworks";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setUidPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addUidPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeUidPolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getUidPolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int[] _result = this.getUidsWithPolicy(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 6: {
                    INetworkPolicyListener _arg0 = INetworkPolicyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    INetworkPolicyListener _arg0 = INetworkPolicyListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    NetworkPolicy[] _arg0 = data.createTypedArray(NetworkPolicy.CREATOR);
                    data.enforceNoDataAvail();
                    this.setNetworkPolicies(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getNetworkPolicies(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 10: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    data.enforceNoDataAvail();
                    this.snoozeLimit(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRestrictBackground(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    boolean _result = this.getRestrictBackground();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    int _result = this.getRestrictBackgroundByCaller();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getRestrictBackgroundStatus(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDeviceIdleMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWifiMeteredOverride(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    Network _arg0 = data.readTypedObject(Network.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getMultipathPreference(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 18: {
                    NetworkTemplate _arg0 = data.readTypedObject(NetworkTemplate.CREATOR);
                    data.enforceNoDataAvail();
                    SubscriptionPlan _result = this.getSubscriptionPlan(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 19: {
                    this.notifyStatsProviderWarningOrLimitReached();
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getSubscriptionPlans(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    SubscriptionPlan[] _arg1 = data.createTypedArray(SubscriptionPlan.CREATOR);
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setSubscriptionPlans(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getSubscriptionPlansOwner(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int[] _arg3 = data.createIntArray();
                    long _arg4 = data.readLong();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.setSubscriptionOverride(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.factoryReset(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.isUidNetworkingBlocked(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isUidRestrictedOnMeteredNetworks(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setUidPolicy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addUidPolicy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeUidPolicy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getUidPolicy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getUidsWithPolicy_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNetworkPolicies_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getNetworkPolicies_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void snoozeLimit_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getRestrictBackground_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getRestrictBackgroundByCaller_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_NETWORK_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDeviceIdleMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setWifiMeteredOverride_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void factoryReset_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.NETWORK_SETTINGS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isUidRestrictedOnMeteredNetworks_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OBSERVE_NETWORK_POLICY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 25;
        }

        private static class Proxy
        implements INetworkPolicyManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUidPolicy(int uid, int policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(policy);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addUidPolicy(int uid, int policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(policy);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUidPolicy(int uid, int policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(policy);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUidPolicy(int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getUidsWithPolicy(int policy) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(policy);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(INetworkPolicyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterListener(INetworkPolicyListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNetworkPolicies(NetworkPolicy[] policies) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(policies, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetworkPolicy[] getNetworkPolicies(String callingPackage) throws RemoteException {
                NetworkPolicy[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(NetworkPolicy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snoozeLimit(NetworkTemplate template) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRestrictBackground(boolean restrictBackground) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(restrictBackground);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getRestrictBackground() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRestrictBackgroundByCaller() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRestrictBackgroundStatus(int uid) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceIdleMode(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWifiMeteredOverride(String networkId, int meteredOverride) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(networkId);
                    _data.writeInt(meteredOverride);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMultipathPreference(Network network) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(network, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionPlan getSubscriptionPlan(NetworkTemplate template) throws RemoteException {
                SubscriptionPlan _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(template, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SubscriptionPlan.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyStatsProviderWarningOrLimitReached() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionPlan[] getSubscriptionPlans(int subId, String callingPackage) throws RemoteException {
                SubscriptionPlan[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(SubscriptionPlan.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSubscriptionPlans(int subId, SubscriptionPlan[] plans, long expirationDurationMillis, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeTypedArray(plans, 0);
                    _data.writeLong(expirationDurationMillis);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSubscriptionPlansOwner(int subId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes, long expirationDurationMillis, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(overrideMask);
                    _data.writeInt(overrideValue);
                    _data.writeIntArray(networkTypes);
                    _data.writeLong(expirationDurationMillis);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void factoryReset(String subscriber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subscriber);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUidNetworkingBlocked(int uid, boolean meteredNetwork) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeBoolean(meteredNetwork);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUidRestrictedOnMeteredNetworks(int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements INetworkPolicyManager {
        @Override
        public void setUidPolicy(int uid, int policy) throws RemoteException {
        }

        @Override
        public void addUidPolicy(int uid, int policy) throws RemoteException {
        }

        @Override
        public void removeUidPolicy(int uid, int policy) throws RemoteException {
        }

        @Override
        public int getUidPolicy(int uid) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getUidsWithPolicy(int policy) throws RemoteException {
            return null;
        }

        @Override
        public void registerListener(INetworkPolicyListener listener) throws RemoteException {
        }

        @Override
        public void unregisterListener(INetworkPolicyListener listener) throws RemoteException {
        }

        @Override
        public void setNetworkPolicies(NetworkPolicy[] policies) throws RemoteException {
        }

        @Override
        public NetworkPolicy[] getNetworkPolicies(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void snoozeLimit(NetworkTemplate template) throws RemoteException {
        }

        @Override
        public void setRestrictBackground(boolean restrictBackground) throws RemoteException {
        }

        @Override
        public boolean getRestrictBackground() throws RemoteException {
            return false;
        }

        @Override
        public int getRestrictBackgroundByCaller() throws RemoteException {
            return 0;
        }

        @Override
        public int getRestrictBackgroundStatus(int uid) throws RemoteException {
            return 0;
        }

        @Override
        public void setDeviceIdleMode(boolean enabled) throws RemoteException {
        }

        @Override
        public void setWifiMeteredOverride(String networkId, int meteredOverride) throws RemoteException {
        }

        @Override
        public int getMultipathPreference(Network network) throws RemoteException {
            return 0;
        }

        @Override
        public SubscriptionPlan getSubscriptionPlan(NetworkTemplate template) throws RemoteException {
            return null;
        }

        @Override
        public void notifyStatsProviderWarningOrLimitReached() throws RemoteException {
        }

        @Override
        public SubscriptionPlan[] getSubscriptionPlans(int subId, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void setSubscriptionPlans(int subId, SubscriptionPlan[] plans, long expirationDurationMillis, String callingPackage) throws RemoteException {
        }

        @Override
        public String getSubscriptionPlansOwner(int subId) throws RemoteException {
            return null;
        }

        @Override
        public void setSubscriptionOverride(int subId, int overrideMask, int overrideValue, int[] networkTypes, long expirationDurationMillis, String callingPackage) throws RemoteException {
        }

        @Override
        public void factoryReset(String subscriber) throws RemoteException {
        }

        @Override
        public boolean isUidNetworkingBlocked(int uid, boolean meteredNetwork) throws RemoteException {
            return false;
        }

        @Override
        public boolean isUidRestrictedOnMeteredNetworks(int uid) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

