/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.NetworkUtils;
import android.net.connectivity.com.android.net.module.util.ConnectivityUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.system.OsConstants;
import android.util.Pair;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class LinkAddress
implements Parcelable {
    @SystemApi
    public static final long LIFETIME_UNKNOWN = -1L;
    @SystemApi
    public static final long LIFETIME_PERMANENT = Long.MAX_VALUE;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private InetAddress address;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private int prefixLength;
    private int flags;
    private int scope;
    private long deprecationTime;
    private long expirationTime;
    @NonNull
    public static final Parcelable.Creator<LinkAddress> CREATOR = new Parcelable.Creator<LinkAddress>(){

        @Override
        public LinkAddress createFromParcel(Parcel in) {
            InetAddress address = null;
            try {
                address = InetAddress.getByAddress(in.createByteArray());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            int prefixLength = in.readInt();
            int flags = in.readInt();
            int scope = in.readInt();
            long deprecationTime = in.readLong();
            long expirationTime = in.readLong();
            return new LinkAddress(address, prefixLength, flags, scope, deprecationTime, expirationTime);
        }

        public LinkAddress[] newArray(int size) {
            return new LinkAddress[size];
        }
    };

    private static int scopeForUnicastAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress()) {
            return OsConstants.RT_SCOPE_HOST;
        }
        if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) {
            return OsConstants.RT_SCOPE_LINK;
        }
        if (!(addr instanceof Inet4Address) && addr.isSiteLocalAddress()) {
            return OsConstants.RT_SCOPE_SITE;
        }
        return OsConstants.RT_SCOPE_UNIVERSE;
    }

    private boolean isIpv6ULA() {
        return ConnectivityUtils.isIPv6ULA(this.address);
    }

    @SystemApi
    public boolean isIpv6() {
        return this.address instanceof Inet6Address;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean isIPv6() {
        return this.isIpv6();
    }

    @SystemApi
    public boolean isIpv4() {
        return this.address instanceof Inet4Address;
    }

    private void init(InetAddress address, int prefixLength, int flags, int scope, long deprecationTime, long expirationTime) {
        if (address == null || address.isMulticastAddress() || prefixLength < 0 || address instanceof Inet4Address && prefixLength > 32 || prefixLength > 128) {
            throw new IllegalArgumentException("Bad LinkAddress params " + address + "/" + prefixLength);
        }
        if (deprecationTime == -1L != (expirationTime == -1L)) {
            throw new IllegalArgumentException("Must not specify only one of deprecation time and expiration time");
        }
        if (deprecationTime != -1L && deprecationTime < 0L) {
            throw new IllegalArgumentException("invalid deprecation time " + deprecationTime);
        }
        if (expirationTime != -1L && expirationTime < 0L) {
            throw new IllegalArgumentException("invalid expiration time " + expirationTime);
        }
        if (deprecationTime != -1L && expirationTime != -1L && expirationTime < deprecationTime) {
            throw new IllegalArgumentException("expiration earlier than deprecation (" + deprecationTime + ", " + expirationTime + ")");
        }
        this.address = address;
        this.prefixLength = prefixLength;
        this.flags = flags;
        this.scope = scope;
        this.deprecationTime = deprecationTime;
        this.expirationTime = expirationTime;
    }

    @SystemApi
    public LinkAddress(@NonNull InetAddress address, int prefixLength, int flags, int scope) {
        this.init(address, prefixLength, flags, scope, -1L, -1L);
    }

    @SystemApi
    public LinkAddress(@NonNull InetAddress address, int prefixLength, int flags, int scope, long deprecationTime, long expirationTime) {
        this.init(address, prefixLength, flags, scope, deprecationTime, expirationTime);
    }

    @SystemApi
    public LinkAddress(@NonNull InetAddress address, int prefixLength) {
        this(address, prefixLength, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(address);
    }

    public LinkAddress(@NonNull InterfaceAddress interfaceAddress) {
        this(interfaceAddress.getAddress(), interfaceAddress.getNetworkPrefixLength());
    }

    @SystemApi
    public LinkAddress(@NonNull String address) {
        this(address, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(this.address);
    }

    @SystemApi
    public LinkAddress(@NonNull String address, int flags, int scope) {
        Pair<InetAddress, Integer> ipAndMask = NetworkUtils.legacyParseIpAndMask(address);
        this.init((InetAddress)ipAndMask.first, (Integer)ipAndMask.second, flags, scope, -1L, -1L);
    }

    public String toString() {
        return this.address.getHostAddress() + "/" + this.prefixLength;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LinkAddress)) {
            return false;
        }
        LinkAddress linkAddress = (LinkAddress)obj;
        return ((Object)this.address).equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength && this.flags == linkAddress.flags && this.scope == linkAddress.scope && this.deprecationTime == linkAddress.deprecationTime && this.expirationTime == linkAddress.expirationTime;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.prefixLength, this.flags, this.scope, this.deprecationTime, this.expirationTime);
    }

    @SystemApi
    public boolean isSameAddressAs(@Nullable LinkAddress other) {
        if (other == null) {
            return false;
        }
        return ((Object)this.address).equals(other.address) && this.prefixLength == other.prefixLength;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    @UnsupportedAppUsage
    public int getNetworkPrefixLength() {
        return this.getPrefixLength();
    }

    public int getFlags() {
        int flags = this.flags;
        if (this.deprecationTime != -1L) {
            flags = SystemClock.elapsedRealtime() >= this.deprecationTime ? (flags |= OsConstants.IFA_F_DEPRECATED) : (flags &= ~OsConstants.IFA_F_DEPRECATED);
        }
        if (this.expirationTime == Long.MAX_VALUE) {
            flags |= OsConstants.IFA_F_PERMANENT;
        } else if (this.expirationTime != -1L) {
            flags &= ~OsConstants.IFA_F_PERMANENT;
        }
        return flags;
    }

    public int getScope() {
        return this.scope;
    }

    @SystemApi
    public long getDeprecationTime() {
        return this.deprecationTime;
    }

    @SystemApi
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @SystemApi
    public boolean isGlobalPreferred() {
        return this.scope == OsConstants.RT_SCOPE_UNIVERSE && !this.isIpv6ULA() && this.isPreferred();
    }

    public boolean isPreferred() {
        int flags = this.getFlags();
        return (long)(flags & (OsConstants.IFA_F_DADFAILED | OsConstants.IFA_F_DEPRECATED)) == 0L && ((long)(flags & OsConstants.IFA_F_TENTATIVE) == 0L || (long)(flags & OsConstants.IFA_F_OPTIMISTIC) != 0L);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.address.getAddress());
        dest.writeInt(this.prefixLength);
        dest.writeInt(this.flags);
        dest.writeInt(this.scope);
        dest.writeLong(this.deprecationTime);
        dest.writeLong(this.expirationTime);
    }
}

