/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class NetworkScore
implements Parcelable {
    private final int mLegacyInt;
    public static final int KEEP_CONNECTED_NONE = 0;
    public static final int KEEP_CONNECTED_FOR_HANDOVER = 1;
    public static final int KEEP_CONNECTED_FOR_TEST = 2;
    public static final int KEEP_CONNECTED_LOCAL_NETWORK = 3;
    public static final int POLICY_YIELD_TO_BAD_WIFI = 1;
    public static final int POLICY_TRANSPORT_PRIMARY = 2;
    public static final int POLICY_EXITING = 3;
    public static final int MIN_AGENT_MANAGED_POLICY = 1;
    public static final int MAX_AGENT_MANAGED_POLICY = 3;
    private final long mPolicies;
    private final int mKeepConnectedReason;
    @NonNull
    public static final Parcelable.Creator<NetworkScore> CREATOR = new Parcelable.Creator<NetworkScore>(){

        @Override
        @NonNull
        public NetworkScore createFromParcel(@NonNull Parcel in) {
            return new NetworkScore(in);
        }

        @NonNull
        public NetworkScore[] newArray(int size) {
            return new NetworkScore[size];
        }
    };

    NetworkScore(int legacyInt, long policies, int keepConnectedReason) {
        this.mLegacyInt = legacyInt;
        this.mPolicies = policies;
        this.mKeepConnectedReason = keepConnectedReason;
    }

    private NetworkScore(@NonNull Parcel in) {
        this.mLegacyInt = in.readInt();
        this.mPolicies = in.readLong();
        this.mKeepConnectedReason = in.readInt();
    }

    public int getLegacyInt() {
        return this.mLegacyInt;
    }

    public int getKeepConnectedReason() {
        return this.mKeepConnectedReason;
    }

    @VisibleForTesting
    public boolean hasPolicy(int policy) {
        return 0L != (this.mPolicies & 1L << policy);
    }

    public long getPolicies() {
        return this.mPolicies;
    }

    public boolean shouldYieldToBadWifi() {
        return this.hasPolicy(1);
    }

    @SystemApi
    public boolean isTransportPrimary() {
        return this.hasPolicy(2);
    }

    @SystemApi
    public boolean isExiting() {
        return this.hasPolicy(3);
    }

    public String toString() {
        return "Score(Policies\u00a0: " + this.mPolicies + ")";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mLegacyInt);
        dest.writeLong(this.mPolicies);
        dest.writeInt(this.mKeepConnectedReason);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private static final long POLICY_NONE = 0L;
        private static final int INVALID_LEGACY_INT = Integer.MIN_VALUE;
        private int mLegacyInt = Integer.MIN_VALUE;
        private int mKeepConnectedReason = 0;
        private int mPolicies = 0;

        @NonNull
        public Builder setLegacyInt(int score) {
            this.mLegacyInt = score;
            return this;
        }

        @NonNull
        public Builder setShouldYieldToBadWifi(boolean val) {
            this.mPolicies = val ? (int)((long)this.mPolicies | 2L) : (int)((long)this.mPolicies & 0xFFFFFFFFFFFFFFFDL);
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setTransportPrimary(boolean val) {
            this.mPolicies = val ? (int)((long)this.mPolicies | 4L) : (int)((long)this.mPolicies & 0xFFFFFFFFFFFFFFFBL);
            return this;
        }

        @SystemApi
        @NonNull
        public Builder setExiting(boolean val) {
            this.mPolicies = val ? (int)((long)this.mPolicies | 8L) : (int)((long)this.mPolicies & 0xFFFFFFFFFFFFFFF7L);
            return this;
        }

        @NonNull
        public Builder setKeepConnectedReason(int reason) {
            this.mKeepConnectedReason = reason;
            return this;
        }

        @NonNull
        public NetworkScore build() {
            return new NetworkScore(this.mLegacyInt, this.mPolicies, this.mKeepConnectedReason);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeepConnectedReason {
    }
}

