/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.annotation.NonNull;
import android.net.IConnectivityManager;
import android.net.Network;
import android.net.SocketKeepalive;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.net.InetAddress;
import java.util.concurrent.Executor;

public class NattSocketKeepalive
extends SocketKeepalive {
    public static final int NATT_PORT = 4500;
    @NonNull
    private final InetAddress mSource;
    @NonNull
    private final InetAddress mDestination;
    private final int mResourceId;

    public NattSocketKeepalive(@NonNull IConnectivityManager service, @NonNull Network network, @NonNull ParcelFileDescriptor pfd, int resourceId, @NonNull InetAddress source, @NonNull InetAddress destination, @NonNull Executor executor, @NonNull SocketKeepalive.Callback callback) {
        super(service, network, pfd, executor, callback);
        this.mSource = source;
        this.mDestination = destination;
        this.mResourceId = resourceId;
    }

    @Override
    protected void startImpl(int intervalSec, int flags, Network underpinnedNetwork) {
        if (0 != (flags & 0xFFFFFFFE)) {
            throw new IllegalArgumentException("Illegal flag value for " + this.getClass().getSimpleName() + " : " + flags);
        }
        boolean automaticOnOffKeepalives = 0 != (flags & 1);
        this.mExecutor.execute(() -> {
            try {
                this.mService.startNattKeepaliveWithFd(this.mNetwork, this.mPfd, this.mResourceId, intervalSec, this.mCallback, this.mSource.getHostAddress(), this.mDestination.getHostAddress(), automaticOnOffKeepalives, underpinnedNetwork);
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error starting socket keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }

    @Override
    protected void stopImpl() {
        this.mExecutor.execute(() -> {
            try {
                this.mService.stopKeepalive(this.mCallback);
            }
            catch (RemoteException e) {
                Log.e("SocketKeepalive", "Error stopping socket keepalive: ", e);
                throw e.rethrowFromSystemServer();
            }
        });
    }
}

