/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.SparseArray;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> boolean isEmpty(@Nullable T[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static <T> boolean isEmpty(@Nullable Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    @NonNull
    public static int[] toIntArray(@NonNull Collection<Integer> list) {
        int[] array2 = new int[list.size()];
        int i = 0;
        for (Integer item : list) {
            array2[i] = item;
            ++i;
        }
        return array2;
    }

    @NonNull
    public static long[] toLongArray(@NonNull Collection<Long> list) {
        long[] array2 = new long[list.size()];
        int i = 0;
        for (Long item : list) {
            array2[i] = item;
            ++i;
        }
        return array2;
    }

    public static <T> boolean all(@NonNull Collection<T> elem, @NonNull Predicate<T> predicate) {
        for (T e : elem) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean any(@NonNull Collection<T> elem, @NonNull Predicate<T> predicate) {
        return CollectionUtils.indexOf(elem, predicate) >= 0;
    }

    public static <T> int indexOf(@NonNull Collection<T> elem, @NonNull Predicate<? super T> predicate) {
        int idx = 0;
        for (T e : elem) {
            if (predicate.test(e)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static <T> boolean any(@NonNull SparseArray<T> array2, @NonNull Predicate<T> predicate) {
        for (int i = 0; i < array2.size(); ++i) {
            if (!predicate.test(array2.valueAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable short[] array2, short value) {
        if (array2 == null) {
            return false;
        }
        for (short element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable int[] array2, int value) {
        if (array2 == null) {
            return false;
        }
        for (int element : array2) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(@Nullable T[] array2, @Nullable T value) {
        return CollectionUtils.indexOf(array2, value) != -1;
    }

    public static <T> int indexOf(@Nullable T[] array2, @Nullable T value) {
        if (array2 == null) {
            return -1;
        }
        for (int i = 0; i < array2.length; ++i) {
            if (!Objects.equals(array2[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfSubArray(@NonNull byte[] haystack, @NonNull byte[] needle) {
        for (int i = 0; i < haystack.length - needle.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < needle.length; ++j) {
                if (haystack[i + j] == needle[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    @NonNull
    public static <T> ArrayList<T> filter(@NonNull Collection<T> source, @NonNull Predicate<T> test) {
        ArrayList<T> matches = new ArrayList<T>();
        for (T e : source) {
            if (!test.test(e)) continue;
            matches.add(e);
        }
        return matches;
    }

    public static long total(@Nullable long[] array2) {
        long total = 0L;
        if (array2 != null) {
            for (long value : array2) {
                total += value;
            }
        }
        return total;
    }

    public static <T> boolean containsAny(@NonNull Collection<T> haystack, @NonNull Collection<? extends T> needles) {
        for (T needle : needles) {
            if (!haystack.contains(needle)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(@NonNull Collection<T> haystack, @NonNull Collection<? extends T> needles) {
        return haystack.containsAll(needles);
    }

    @Nullable
    public static <T> T findFirst(@NonNull Collection<T> haystack, @NonNull Predicate<? super T> condition) {
        for (T needle : haystack) {
            if (!condition.test(needle)) continue;
            return needle;
        }
        return null;
    }

    @Nullable
    public static <T> T findLast(@NonNull List<T> haystack, @NonNull Predicate<? super T> condition) {
        for (int i = haystack.size() - 1; i >= 0; --i) {
            T needle = haystack.get(i);
            if (!condition.test(needle)) continue;
            return needle;
        }
        return null;
    }

    public static <T> boolean contains(@NonNull Collection<T> haystack, @NonNull Predicate<? super T> condition) {
        return -1 != CollectionUtils.indexOf(haystack, condition);
    }

    @NonNull
    public static <T, R> ArrayList<R> map(@NonNull Collection<T> source, @NonNull Function<? super T, ? extends R> transform) {
        ArrayList<R> dest = new ArrayList<R>(source.size());
        for (T e : source) {
            dest.add(transform.apply(e));
        }
        return dest;
    }

    @NonNull
    public static <T, R> ArrayList<Pair<T, R>> zip(@NonNull List<T> first, @NonNull List<R> second) {
        int size = first.size();
        if (size != second.size()) {
            throw new IllegalArgumentException("zip : collections must be the same size");
        }
        ArrayList<Pair<T, R>> dest = new ArrayList<Pair<T, R>>(size);
        for (int i = 0; i < size; ++i) {
            dest.add(new Pair<T, R>(first.get(i), second.get(i)));
        }
        return dest;
    }

    @NonNull
    public static <T, R> ArrayMap<T, R> assoc(@NonNull List<T> keys, @NonNull List<R> values) {
        int size = keys.size();
        if (size != values.size()) {
            throw new IllegalArgumentException("assoc : collections must be the same size");
        }
        ArrayMap<T, R> dest = new ArrayMap<T, R>(size);
        for (int i = 0; i < size; ++i) {
            T key = keys.get(i);
            if (dest.containsKey(key)) {
                throw new IllegalArgumentException("assoc : keys may not contain the same value twice");
            }
            dest.put(key, values.get(i));
        }
        return dest;
    }

    public static <T> int getIndexForValue(SparseArray<T> sparseArray, T value) {
        int nsize = sparseArray.size();
        for (int i = 0; i < nsize; ++i) {
            T valueAt = sparseArray.valueAt(i);
            if (!(valueAt == null ? value == null : valueAt.equals(value))) continue;
            return i;
        }
        return -1;
    }

    public static byte[] concatArrays(byte[] ... arr) {
        int size = 0;
        for (byte[] a : arr) {
            size += a.length;
        }
        byte[] result = new byte[size];
        int offset = 0;
        for (byte[] a : arr) {
            System.arraycopy(a, 0, result, offset, a.length);
            offset += a.length;
        }
        return result;
    }

    public static <T> T[] concatArrays(@NonNull Class<T> clazz, T[] ... arr) {
        int size = 0;
        for (T[] a : arr) {
            size += a.length;
        }
        Object[] result = (Object[])Array.newInstance(clazz, size);
        int offset = 0;
        for (T[] a : arr) {
            System.arraycopy(a, 0, result, offset, a.length);
            offset += a.length;
        }
        return result;
    }

    public static byte[] prependArray(@NonNull byte[] suffix, byte ... prefixes) {
        return CollectionUtils.concatArrays(prefixes, suffix);
    }

    public static <T> T[] prependArray(@NonNull Class<T> clazz, @NonNull T[] suffix, T ... prefixes) {
        return CollectionUtils.concatArrays(clazz, prefixes, suffix);
    }

    public static byte[] appendArray(@NonNull byte[] prefix, byte ... suffixes) {
        return CollectionUtils.concatArrays(prefix, suffixes);
    }

    public static <T> T[] appendArray(@NonNull Class<T> clazz, @NonNull T[] prefix, T ... suffixes) {
        return CollectionUtils.concatArrays(clazz, prefix, suffixes);
    }
}

