/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.base.CommandLineJni;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.jni_zero.JniType;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class CommandLine {
    private static final AtomicReference<CommandLine> sCommandLine = new AtomicReference();
    private static final String TAG = "CommandLine";
    private static final String SWITCH_PREFIX = "--";
    private static final String SWITCH_TERMINATOR = "--";
    private static final String SWITCH_VALUE_SEPARATOR = "=";

    public abstract boolean hasSwitch(String var1);

    @Nullable
    public abstract String getSwitchValue(String var1);

    public String getSwitchValue(String switchString, String defaultValue) {
        String value = this.getSwitchValue(switchString);
        return TextUtils.isEmpty(value) ? defaultValue : value;
    }

    public abstract Map<String, String> getSwitches();

    public abstract void appendSwitch(String var1);

    public abstract void appendSwitchWithValue(String var1, String var2);

    public abstract void appendSwitchesAndArguments(String[] var1);

    public abstract void removeSwitch(String var1);

    public static boolean isNativeImplementationForTesting() {
        return sCommandLine.get() instanceof NativeCommandLine;
    }

    public static boolean isInitialized() {
        return sCommandLine.get() != null;
    }

    public static CommandLine getInstance() {
        CommandLine commandLine = sCommandLine.get();
        assert (commandLine != null);
        return commandLine;
    }

    public static void init(@Nullable String[] args) {
        assert (!(sCommandLine.get() instanceof NativeCommandLine));
        sCommandLine.set(new JavaCommandLine(args));
    }

    public static void initFromFile(String file) {
        char[] buffer = CommandLine.readFileAsUtf8(file);
        Object[] tokenized = buffer == null ? null : CommandLine.tokenizeQuotedArguments(buffer);
        CommandLine.init((String[])tokenized);
        if (tokenized != null) {
            Log.i(TAG, "COMMAND-LINE FLAGS: %s (from %s)", (Object)Arrays.toString(tokenized), (Object)file);
        }
    }

    public static void resetForTesting(boolean initialize) {
        CommandLine origCommandLine = sCommandLine.getAndSet(initialize ? new JavaCommandLine(null) : null);
        ResettersForTesting.register(() -> sCommandLine.set(origCommandLine));
    }

    @VisibleForTesting
    static String[] tokenizeQuotedArguments(char[] buffer) {
        if (buffer.length > 98304) {
            throw new RuntimeException("Flags file too big: " + buffer.length);
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder arg = null;
        boolean noQuote = false;
        int singleQuote = 39;
        int doubleQuote = 34;
        char currentQuote = '\u0000';
        for (char c : buffer) {
            if (currentQuote == '\u0000' && (c == '\'' || c == '\"') || c == currentQuote) {
                if (arg != null && arg.length() > 0 && arg.charAt(arg.length() - 1) == '\\') {
                    arg.setCharAt(arg.length() - 1, c);
                    continue;
                }
                currentQuote = currentQuote == '\u0000' ? c : (char)'\u0000';
                continue;
            }
            if (currentQuote == '\u0000' && Character.isWhitespace(c)) {
                if (arg == null) continue;
                args.add(arg.toString());
                arg = null;
                continue;
            }
            if (arg == null) {
                arg = new StringBuilder();
            }
            arg.append(c);
        }
        if (arg != null) {
            if (currentQuote != '\u0000') {
                Log.w(TAG, "Unterminated quoted string: %s", (Object)arg);
            }
            args.add(arg.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    public static void enableNativeProxy() {
        JavaCommandLine prev = (JavaCommandLine)sCommandLine.get();
        String[] args = prev == null ? new String[]{} : prev.getCommandLineArguments();
        CommandLineJni.get().init(args);
        sCommandLine.set(new NativeCommandLine());
        Log.v(TAG, "Switched to native command-line", new Object[0]);
    }

    public static String[] getJavaSwitchesForTesting() {
        CommandLine commandLine = sCommandLine.get();
        if (commandLine != null) {
            return ((JavaCommandLine)commandLine).getCommandLineArguments();
        }
        return new String[0];
    }

    private static char[] readFileAsUtf8(String fileName) {
        char[] cArray;
        File f = new File(fileName);
        FileReader reader = new FileReader(f);
        try {
            char[] buffer = new char[(int)f.length()];
            int charsRead = reader.read(buffer);
            cArray = Arrays.copyOfRange(buffer, 0, charsRead);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return cArray;
    }

    private CommandLine() {
    }

    private static class NativeCommandLine
    extends CommandLine {
        private NativeCommandLine() {
        }

        @Override
        public boolean hasSwitch(String switchString) {
            return CommandLineJni.get().hasSwitch(switchString);
        }

        @Override
        @Nullable
        public String getSwitchValue(String switchString) {
            String ret = CommandLineJni.get().getSwitchValue(switchString);
            return ret.isEmpty() ? null : ret;
        }

        @Override
        public Map<String, String> getSwitches() {
            HashMap<String, String> switches = new HashMap<String, String>();
            String[] keysAndValues = CommandLineJni.get().getSwitchesFlattened();
            assert (keysAndValues.length % 2 == 0) : "must have same number of keys and values";
            for (int i = 0; i < keysAndValues.length; i += 2) {
                String key = keysAndValues[i];
                String value = keysAndValues[i + 1];
                switches.put(key, value);
            }
            return switches;
        }

        @Override
        public void appendSwitch(String switchString) {
            CommandLineJni.get().appendSwitch(switchString);
        }

        @Override
        public void appendSwitchWithValue(String switchString, String value) {
            CommandLineJni.get().appendSwitchWithValue(switchString, value == null ? "" : value);
        }

        @Override
        public void appendSwitchesAndArguments(String[] array2) {
            CommandLineJni.get().appendSwitchesAndArguments(array2);
        }

        @Override
        public void removeSwitch(String switchString) {
            CommandLineJni.get().removeSwitch(switchString);
        }
    }

    @VisibleForTesting
    static class JavaCommandLine
    extends CommandLine {
        private HashMap<String, String> mSwitches = new HashMap();
        private ArrayList<String> mArgs = new ArrayList();
        private int mArgsBegin = 1;

        JavaCommandLine(@Nullable String[] args) {
            if (args == null || args.length == 0 || args[0] == null) {
                this.mArgs.add("");
            } else {
                this.mArgs.add(args[0]);
                this.appendSwitchesInternal(args, 1);
            }
            assert (this.mArgs.size() > 0);
        }

        String[] getCommandLineArguments() {
            return this.mArgs.toArray(new String[this.mArgs.size()]);
        }

        @Override
        public boolean hasSwitch(String switchString) {
            return this.mSwitches.containsKey(switchString);
        }

        @Override
        @Nullable
        public String getSwitchValue(String switchString) {
            String value = this.mSwitches.get(switchString);
            return TextUtils.isEmpty(value) ? null : value;
        }

        @Override
        public Map<String, String> getSwitches() {
            return new HashMap<String, String>(this.mSwitches);
        }

        @Override
        public void appendSwitch(String switchString) {
            this.appendSwitchWithValue(switchString, null);
        }

        @Override
        public void appendSwitchWithValue(String switchString, @Nullable String value) {
            this.mSwitches.put(switchString, value == null ? "" : value);
            String combinedSwitchString = "--" + switchString;
            if (value != null && !value.isEmpty()) {
                combinedSwitchString = combinedSwitchString + CommandLine.SWITCH_VALUE_SEPARATOR + value;
            }
            this.mArgs.add(this.mArgsBegin++, combinedSwitchString);
        }

        @Override
        public void appendSwitchesAndArguments(String[] array2) {
            this.appendSwitchesInternal(array2, 0);
        }

        private void appendSwitchesInternal(String[] array2, int skipCount) {
            boolean parseSwitches = true;
            for (String arg : array2) {
                if (skipCount > 0) {
                    --skipCount;
                    continue;
                }
                if (arg.equals("--")) {
                    parseSwitches = false;
                }
                if (parseSwitches && arg.startsWith("--")) {
                    String[] parts = arg.split(CommandLine.SWITCH_VALUE_SEPARATOR, 2);
                    String value = parts.length > 1 ? parts[1] : null;
                    this.appendSwitchWithValue(parts[0].substring("--".length()), value);
                    continue;
                }
                this.mArgs.add(arg);
            }
        }

        @Override
        public void removeSwitch(String switchString) {
            this.mSwitches.remove(switchString);
            String combinedSwitchString = "--" + switchString;
            for (int i = this.mArgsBegin - 1; i > 0; --i) {
                if (!this.mArgs.get(i).equals(combinedSwitchString) && !this.mArgs.get(i).startsWith(combinedSwitchString + CommandLine.SWITCH_VALUE_SEPARATOR)) continue;
                --this.mArgsBegin;
                this.mArgs.remove(i);
            }
        }
    }

    static interface Natives {
        public void init(@JniType(value="std::vector<std::string>") String[] var1);

        public boolean hasSwitch(@JniType(value="std::string") String var1);

        public @JniType(value="std::string") String getSwitchValue(@JniType(value="std::string") String var1);

        public @JniType(value="std::vector<std::string>") String[] getSwitchesFlattened();

        public void appendSwitch(@JniType(value="std::string") String var1);

        public void appendSwitchWithValue(@JniType(value="std::string") String var1, @JniType(value="std::string") String var2);

        public void appendSwitchesAndArguments(@JniType(value="std::vector<std::string>") String[] var1);

        public void removeSwitch(@JniType(value="std::string") String var1);
    }
}

