/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.build.BuildConfig;
import com.android.layoutlib.androidx.annotation.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public class ResettersForTesting {
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static LinkedHashSet<Runnable> sClassResetters;
    @GuardedBy(value="sLock")
    private static LinkedHashSet<Runnable> sMethodResetters;
    @GuardedBy(value="sLock")
    private static int sState;
    @GuardedBy(value="sLock")
    private static boolean sIsFlushing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Runnable runnable) {
        if (!BuildConfig.IS_FOR_TEST) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (sIsFlushing) {
                throw new IllegalStateException("ResettersForTesting.register() called from within a resetting callback.");
            }
            switch (sState) {
                case 0: {
                    break;
                }
                case 1: {
                    sClassResetters.add(runnable);
                    break;
                }
                case 2: {
                    sClassResetters.add(runnable);
                    break;
                }
                case 3: {
                    sMethodResetters.add(runnable);
                    break;
                }
                case 4: {
                    sMethodResetters.add(runnable);
                }
            }
        }
    }

    @GuardedBy(value="sLock")
    private static void flushResetters(LinkedHashSet<Runnable> activeSet) {
        assert (!sIsFlushing) : "Re-entrancy detected in ResettersForTesting";
        ArrayList<Runnable> resetters = new ArrayList<Runnable>(activeSet);
        activeSet.clear();
        Collections.reverse(resetters);
        sIsFlushing = true;
        Throwable firstError = null;
        for (Runnable resetter : resetters) {
            try {
                resetter.run();
            }
            catch (Throwable t) {
                if (firstError != null) continue;
                firstError = t;
            }
        }
        sIsFlushing = false;
        if (firstError != null) {
            throw new RuntimeException(firstError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beforeClassHooksWillExecute() {
        Object object = sLock;
        synchronized (object) {
            assert (sState == 1) : "Invalid state transition from state " + sState;
            sState = 2;
            ResettersForTesting.flushResetters(sClassResetters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beforeHooksWillExecute() {
        Object object = sLock;
        synchronized (object) {
            assert (sState == 2 || sState == 3) : "Invalid state transition from state " + sState;
            sState = 4;
            ResettersForTesting.flushResetters(sMethodResetters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterHooksDidExecute() {
        Object object = sLock;
        synchronized (object) {
            assert (sState == 4) : "Invalid state transition from state " + sState;
            sState = 3;
            ResettersForTesting.flushResetters(sMethodResetters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterClassHooksDidExecute() {
        Object object = sLock;
        synchronized (object) {
            assert (sState == 2 || sState == 3) : "Invalid state transition from state " + sState;
            sState = 1;
            ResettersForTesting.flushResetters(sMethodResetters);
            ResettersForTesting.flushResetters(sClassResetters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enable() {
        assert (BuildConfig.IS_FOR_TEST);
        Object object = sLock;
        synchronized (object) {
            assert (sState == 0);
            sState = 1;
            sMethodResetters = new LinkedHashSet();
            sClassResetters = new LinkedHashSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getState() {
        Object object = sLock;
        synchronized (object) {
            return sState;
        }
    }

    static {
        sState = 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
        public static final int NOT_ENABLED = 0;
        public static final int BETWEEN_CLASSES = 1;
        public static final int CLASS_SCOPED = 2;
        public static final int BETWEEN_METHODS = 3;
        public static final int METHOD_SCOPED = 4;
    }
}

