/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net;

import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.TransportInfo;
import android.net.connectivity.org.chromium.base.ApiCompatibilityUtils;
import android.net.connectivity.org.chromium.base.ContextUtils;
import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.chromium.net.AndroidCertVerifyResult;
import android.net.connectivity.org.chromium.net.DnsStatus;
import android.net.connectivity.org.chromium.net.ThreadStatsUid;
import android.net.connectivity.org.chromium.net.X509Util;
import android.net.connectivity.org.jni_zero.CalledByNative;
import android.net.connectivity.org.jni_zero.CalledByNativeForTesting;
import android.net.connectivity.org.jni_zero.CalledByNativeUnchecked;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os._Original_Build;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URLConnection;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.List;

class AndroidNetworkLibrary {
    private static final String TAG = "AndroidNetworkLibrary";
    private static Boolean sHaveAccessNetworkState;
    private static Boolean sHaveAccessWifiState;

    AndroidNetworkLibrary() {
    }

    @CalledByNative
    public static String getMimeTypeFromExtension(String extension) {
        return URLConnection.guessContentTypeFromName("foo." + extension);
    }

    @CalledByNative
    public static boolean haveOnlyLoopbackAddresses() {
        Enumeration<NetworkInterface> list = null;
        try {
            list = NetworkInterface.getNetworkInterfaces();
            if (list == null) {
                return false;
            }
        }
        catch (Exception e) {
            Log.w(TAG, "could not get network interfaces: " + e);
            return false;
        }
        while (list.hasMoreElements()) {
            NetworkInterface netIf = list.nextElement();
            try {
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                return false;
            }
            catch (SocketException e) {
            }
        }
        return true;
    }

    @CalledByNative
    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, String authType, String host) {
        try {
            return X509Util.verifyServerCertificates(certChain, authType, host);
        }
        catch (KeyStoreException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (NoSuchAlgorithmException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (IllegalArgumentException e) {
            return new AndroidCertVerifyResult(-1);
        }
    }

    @CalledByNative
    public static byte[][] getUserAddedRoots() {
        return X509Util.getUserAddedRoots();
    }

    @CalledByNativeUnchecked
    public static void addTestRootCertificate(byte[] rootCert) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.addTestRootCertificate(rootCert);
    }

    @CalledByNativeUnchecked
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.clearTestRootCertificates();
    }

    @CalledByNative
    private static String getNetworkOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getNetworkOperator();
    }

    @CalledByNative
    private static boolean getIsRoaming() {
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isRoaming();
    }

    @RequiresApi(value=23)
    @CalledByNative
    private static boolean getIsCaptivePortal() {
        if (_Original_Build.VERSION.SDK_INT < 23) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(17);
    }

    private static WifiInfo getWifiInfo() {
        if (AndroidNetworkLibrary.haveAccessWifiState()) {
            if (_Original_Build.VERSION.SDK_INT >= 31) {
                Network[] allNetworks;
                ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
                for (Network network : allNetworks = connectivityManager.getAllNetworks()) {
                    TransportInfo transportInfo;
                    NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                    if (networkCapabilities == null || !networkCapabilities.hasTransport(1) || (transportInfo = networkCapabilities.getTransportInfo()) == null || !(transportInfo instanceof WifiInfo)) continue;
                    return (WifiInfo)transportInfo;
                }
                return null;
            }
            WifiManager wifiManager = (WifiManager)ContextUtils.getApplicationContext().getSystemService("wifi");
            return wifiManager.getConnectionInfo();
        }
        Intent intent = ContextUtils.registerProtectedBroadcastReceiver(ContextUtils.getApplicationContext(), null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
        if (intent != null) {
            return (WifiInfo)intent.getParcelableExtra("wifiInfo");
        }
        return null;
    }

    @CalledByNative
    public static String getWifiSSID() {
        String ssid;
        WifiInfo wifiInfo = AndroidNetworkLibrary.getWifiInfo();
        if (wifiInfo != null && (ssid = wifiInfo.getSSID()) != null && !ssid.equals("<unknown ssid>")) {
            return ssid;
        }
        return "";
    }

    @CalledByNativeForTesting
    public static void setWifiEnabledForTesting(boolean enabled) {
        WifiManager wifiManager = (WifiManager)ContextUtils.getApplicationContext().getSystemService("wifi");
        boolean oldValue = wifiManager.isWifiEnabled();
        wifiManager.setWifiEnabled(enabled);
        ResettersForTesting.register(() -> wifiManager.setWifiEnabled(oldValue));
    }

    @CalledByNative
    public static int getWifiSignalLevel(int countBuckets) {
        int rssi;
        if (ContextUtils.getApplicationContext() == null) {
            return -1;
        }
        if (ContextUtils.getApplicationContext().getContentResolver() == null) {
            return -1;
        }
        if (AndroidNetworkLibrary.haveAccessWifiState()) {
            WifiInfo wifiInfo = AndroidNetworkLibrary.getWifiInfo();
            if (wifiInfo == null) {
                return -1;
            }
            rssi = wifiInfo.getRssi();
        } else {
            Intent intent = null;
            try {
                intent = ContextUtils.registerProtectedBroadcastReceiver(ContextUtils.getApplicationContext(), null, new IntentFilter("android.net.wifi.RSSI_CHANGED"));
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
            if (intent == null) {
                return -1;
            }
            rssi = intent.getIntExtra("newRssi", Integer.MIN_VALUE);
        }
        if (rssi == Integer.MIN_VALUE) {
            return -1;
        }
        int signalLevel = WifiManager.calculateSignalLevel(rssi, countBuckets);
        if (signalLevel < 0 || signalLevel >= countBuckets) {
            return -1;
        }
        return signalLevel;
    }

    @CalledByNative
    @RequiresApi(value=24)
    private static boolean isCleartextPermitted(String host) {
        try {
            return NetworkSecurityPolicyProxy.getInstance().isCleartextTrafficPermitted(host);
        }
        catch (IllegalArgumentException e) {
            return NetworkSecurityPolicyProxy.getInstance().isCleartextTrafficPermitted();
        }
    }

    private static boolean haveAccessNetworkState() {
        if (sHaveAccessNetworkState == null) {
            sHaveAccessNetworkState = ApiCompatibilityUtils.checkPermission(ContextUtils.getApplicationContext(), "android.permission.ACCESS_NETWORK_STATE", Process.myPid(), Process.myUid()) == 0;
        }
        return sHaveAccessNetworkState;
    }

    private static boolean haveAccessWifiState() {
        if (sHaveAccessWifiState == null) {
            sHaveAccessWifiState = ApiCompatibilityUtils.checkPermission(ContextUtils.getApplicationContext(), "android.permission.ACCESS_WIFI_STATE", Process.myPid(), Process.myUid()) == 0;
        }
        return sHaveAccessWifiState;
    }

    @RequiresApi(value=28)
    @CalledByNative
    public static DnsStatus getDnsStatusForNetwork(long networkHandle) {
        try {
            Network network = Network.fromNetworkHandle(networkHandle);
            return AndroidNetworkLibrary.getDnsStatus(network);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @RequiresApi(value=23)
    @CalledByNative
    public static DnsStatus getCurrentDnsStatus() {
        return AndroidNetworkLibrary.getDnsStatus(null);
    }

    @RequiresApi(value=23)
    public static DnsStatus getDnsStatus(Network network) {
        LinkProperties linkProperties;
        if (!AndroidNetworkLibrary.haveAccessNetworkState()) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return null;
        }
        if (network == null) {
            network = connectivityManager.getActiveNetwork();
        }
        if (network == null) {
            return null;
        }
        try {
            linkProperties = connectivityManager.getLinkProperties(network);
        }
        catch (RuntimeException e) {
            return null;
        }
        if (linkProperties == null) {
            return null;
        }
        List<InetAddress> dnsServersList = linkProperties.getDnsServers();
        String searchDomains = linkProperties.getDomains();
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return new DnsStatus(dnsServersList, linkProperties.isPrivateDnsActive(), linkProperties.getPrivateDnsServerName(), searchDomains);
        }
        return new DnsStatus(dnsServersList, false, "", searchDomains);
    }

    @RequiresApi(value=23)
    @CalledByNative
    private static boolean reportBadDefaultNetwork() {
        if (_Original_Build.VERSION.SDK_INT < 23) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        connectivityManager.reportNetworkConnectivity(null, false);
        return true;
    }

    @CalledByNative
    private static void tagSocket(int ifd, int uid, int tag) throws IOException {
        FileDescriptor fd;
        ParcelFileDescriptor pfd;
        int oldTag = TrafficStats.getThreadStatsTag();
        if (tag != oldTag) {
            TrafficStats.setThreadStatsTag(tag);
        }
        if (uid != -1) {
            ThreadStatsUid.set(uid);
        }
        if (_Original_Build.VERSION.SDK_INT < 23) {
            pfd = null;
            fd = SetFileDescriptor.createWithFd(ifd);
        } else {
            pfd = ParcelFileDescriptor.adoptFd(ifd);
            fd = pfd.getFileDescriptor();
        }
        SocketFd s = new SocketFd(fd);
        TrafficStats.tagSocket(s);
        s.close();
        if (pfd != null) {
            pfd.detachFd();
        }
        if (tag != oldTag) {
            TrafficStats.setThreadStatsTag(oldTag);
        }
        if (uid != -1) {
            ThreadStatsUid.clear();
        }
    }

    public static class NetworkSecurityPolicyProxy {
        private static NetworkSecurityPolicyProxy sInstance = new NetworkSecurityPolicyProxy();

        public static NetworkSecurityPolicyProxy getInstance() {
            return sInstance;
        }

        public static void setInstanceForTesting(NetworkSecurityPolicyProxy networkSecurityPolicyProxy) {
            NetworkSecurityPolicyProxy oldValue = sInstance;
            sInstance = networkSecurityPolicyProxy;
            ResettersForTesting.register(() -> {
                sInstance = oldValue;
            });
        }

        @RequiresApi(value=24)
        public boolean isCleartextTrafficPermitted(String host) {
            if (_Original_Build.VERSION.SDK_INT < 24) {
                return this.isCleartextTrafficPermitted();
            }
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(host);
        }

        @RequiresApi(value=23)
        public boolean isCleartextTrafficPermitted() {
            if (_Original_Build.VERSION.SDK_INT < 23) {
                return true;
            }
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
    }

    private static class SetFileDescriptor {
        private static final Method sFileDescriptorSetInt;

        private SetFileDescriptor() {
        }

        public static FileDescriptor createWithFd(int fd) {
            try {
                FileDescriptor fileDescriptor = new FileDescriptor();
                sFileDescriptorSetInt.invoke((Object)fileDescriptor, fd);
                return fileDescriptor;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", e);
            }
        }

        static {
            try {
                sFileDescriptorSetInt = FileDescriptor.class.getMethod("setInt$", Integer.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Unable to get FileDescriptor.setInt$", e);
            }
        }
    }

    private static class SocketFd
    extends Socket {
        SocketFd(FileDescriptor fd) throws IOException {
            super(new SocketImplFd(fd));
        }

        private static class SocketImplFd
        extends SocketImpl {
            SocketImplFd(FileDescriptor fd) {
                this.fd = fd;
            }

            @Override
            protected void accept(SocketImpl s) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected int available() {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected void bind(InetAddress host, int port) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected void close() {
            }

            @Override
            protected void connect(InetAddress address, int port) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void connect(SocketAddress address, int timeout) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void connect(String host, int port) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void create(boolean stream) {
            }

            @Override
            protected InputStream getInputStream() {
                throw new RuntimeException("getInputStream not implemented");
            }

            @Override
            protected OutputStream getOutputStream() {
                throw new RuntimeException("getOutputStream not implemented");
            }

            @Override
            protected void listen(int backlog) {
                throw new RuntimeException("listen not implemented");
            }

            @Override
            protected void sendUrgentData(int data) {
                throw new RuntimeException("sendUrgentData not implemented");
            }

            @Override
            public Object getOption(int optID) {
                throw new RuntimeException("getOption not implemented");
            }

            @Override
            public void setOption(int optID, Object value) {
                throw new RuntimeException("setOption not implemented");
            }
        }
    }
}

