/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.httpflags;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.httpflags.Flags;
import android.os._Original_Build;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class HttpFlagsLoader {
    @VisibleForTesting
    static final String FLAGS_FILE_PROVIDER_INTENT_ACTION = "android.net.http.FLAGS_FILE_PROVIDER";
    @VisibleForTesting
    static final String FLAGS_FILE_DIR_NAME = "app_httpflags";
    @VisibleForTesting
    static final String FLAGS_FILE_NAME = "flags.binarypb";
    private static final String TAG = "HttpFlagsLoader";

    private HttpFlagsLoader() {
    }

    @Nullable
    public static Flags load(Context context) {
        try {
            ApplicationInfo providerApplicationInfo = HttpFlagsLoader.getProviderApplicationInfo(context);
            if (providerApplicationInfo == null) {
                return null;
            }
            Log.d(TAG, "Found application exporting HTTP flags: %s", providerApplicationInfo.packageName);
            File flagsFile = HttpFlagsLoader.getFlagsFileFromProvider(providerApplicationInfo);
            Log.d(TAG, "HTTP flags file path: %s", flagsFile.getAbsolutePath());
            Flags flags = HttpFlagsLoader.loadFlagsFile(flagsFile);
            if (flags == null) {
                return null;
            }
            Log.d(TAG, "Successfully loaded HTTP flags: %s", flags);
            return flags;
        }
        catch (RuntimeException exception) {
            Log.i(TAG, "Unable to load HTTP flags file", exception);
            return null;
        }
    }

    @Nullable
    private static ApplicationInfo getProviderApplicationInfo(Context context) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("HttpFlagsLoader#getProviderApplicationInfo");){
            ResolveInfo resolveInfo = context.getPackageManager().resolveService(new Intent(FLAGS_FILE_PROVIDER_INTENT_ACTION), 0x100000);
            if (resolveInfo == null) {
                Log.i(TAG, "Unable to resolve the HTTP flags file provider package. This is expected if the host system is not set up to provide HTTP flags.");
                ApplicationInfo applicationInfo = null;
                return applicationInfo;
            }
            ApplicationInfo applicationInfo = resolveInfo.serviceInfo.applicationInfo;
            return applicationInfo;
        }
    }

    private static File getFlagsFileFromProvider(ApplicationInfo providerApplicationInfo) {
        return new File(new File(new File(_Original_Build.VERSION.SDK_INT >= 24 ? providerApplicationInfo.deviceProtectedDataDir : providerApplicationInfo.dataDir), FLAGS_FILE_DIR_NAME), FLAGS_FILE_NAME);
    }

    @Nullable
    private static Flags loadFlagsFile(File file) {
        ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("HttpFlagsLoader#loadFlagsFile");
        try {
            Flags flags;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                flags = Flags.parseDelimitedFrom(fileInputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException exception) {
                    Log.i(TAG, "HTTP flags file `%s` is missing. This is expected if HTTP flags functionality is currently disabled in the host system.", (Object)file.getPath());
                    Flags flags2 = null;
                    return flags2;
                }
                catch (IOException exception) {
                    throw new RuntimeException("Unable to read HTTP flags file", exception);
                }
            }
            fileInputStream.close();
            return flags;
        }
        finally {
            if (traceEvent != null) {
                try {
                    traceEvent.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    throwable3.addSuppressed(throwable);
                }
            }
        }
    }
}

