/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import java.time.Duration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CronetLogger {
    public abstract long generateId();

    public abstract void logCronetEngineBuilderInitializedInfo(CronetEngineBuilderInitializedInfo var1);

    public abstract void logCronetInitializedInfo(CronetInitializedInfo var1);

    public abstract void logCronetEngineCreation(long var1, CronetEngineBuilderInfo var3, CronetVersion var4, CronetSource var5);

    public abstract void logCronetTrafficInfo(long var1, CronetTrafficInfo var3);

    public static class CronetVersion {
        private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
        private final int mMajorVersion;
        private final int mMinorVersion;
        private final int mBuildVersion;
        private final int mPatchVersion;

        public CronetVersion(String version) {
            Matcher m = VERSION_PATTERN.matcher(version);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid version: expected a string matching " + VERSION_PATTERN + ", got " + version);
            }
            this.mMajorVersion = Integer.parseInt(m.group(1));
            this.mMinorVersion = Integer.parseInt(m.group(2));
            this.mBuildVersion = Integer.parseInt(m.group(3));
            this.mPatchVersion = Integer.parseInt(m.group(4));
        }

        public int getMajorVersion() {
            return this.mMajorVersion;
        }

        public int getMinorVersion() {
            return this.mMinorVersion;
        }

        public int getBuildVersion() {
            return this.mBuildVersion;
        }

        public int getPatchVersion() {
            return this.mPatchVersion;
        }

        public String toString() {
            return "" + this.mMajorVersion + "." + this.mMinorVersion + "." + this.mBuildVersion + "." + this.mPatchVersion;
        }
    }

    public static class CronetTrafficInfo {
        private final long mRequestHeaderSizeInBytes;
        private final long mRequestBodySizeInBytes;
        private final long mResponseHeaderSizeInBytes;
        private final long mResponseBodySizeInBytes;
        private final int mResponseStatusCode;
        private final Duration mHeadersLatency;
        private final Duration mTotalLatency;
        private final String mNegotiatedProtocol;
        private final boolean mWasConnectionMigrationAttempted;
        private final boolean mDidConnectionMigrationSucceed;
        private final RequestTerminalState mTerminalState;
        private final int mNonfinalUserCallbackExceptionCount;
        private final int mReadCount;
        private final int mOnUploadReadCount;
        private final boolean mIsBidiStream;
        private final boolean mFinalUserCallbackThrew;
        private final int mUid;
        private final int mNetworkInternalErrorCode;
        private final int mQuicErrorCode;
        private final int mSource;
        private final RequestFailureReason mFailureReason;
        private final boolean mSocketReused;

        public CronetTrafficInfo(long requestHeaderSizeInBytes, long requestBodySizeInBytes, long responseHeaderSizeInBytes, long responseBodySizeInBytes, int responseStatusCode, Duration headersLatency, Duration totalLatency, String negotiatedProtocol, boolean wasConnectionMigrationAttempted, boolean didConnectionMigrationSucceed, RequestTerminalState terminalState, int nonfinalUserCallbackExceptionCount, int readCount, int uploadReadCount, boolean isBidiStream, boolean finalUserCallbackThrew, int uid, int networkInternalErrorCode, int quicErrorCode, int source, RequestFailureReason failureReason, boolean sockedReused) {
            this.mRequestHeaderSizeInBytes = requestHeaderSizeInBytes;
            this.mRequestBodySizeInBytes = requestBodySizeInBytes;
            this.mResponseHeaderSizeInBytes = responseHeaderSizeInBytes;
            this.mResponseBodySizeInBytes = responseBodySizeInBytes;
            this.mResponseStatusCode = responseStatusCode;
            this.mHeadersLatency = headersLatency;
            this.mTotalLatency = totalLatency;
            this.mNegotiatedProtocol = negotiatedProtocol;
            this.mWasConnectionMigrationAttempted = wasConnectionMigrationAttempted;
            this.mDidConnectionMigrationSucceed = didConnectionMigrationSucceed;
            this.mTerminalState = terminalState;
            this.mNonfinalUserCallbackExceptionCount = nonfinalUserCallbackExceptionCount;
            this.mReadCount = readCount;
            this.mOnUploadReadCount = uploadReadCount;
            this.mIsBidiStream = isBidiStream;
            this.mFinalUserCallbackThrew = finalUserCallbackThrew;
            this.mUid = uid;
            this.mNetworkInternalErrorCode = networkInternalErrorCode;
            this.mQuicErrorCode = quicErrorCode;
            this.mSource = source;
            this.mFailureReason = failureReason;
            this.mSocketReused = sockedReused;
        }

        public long getRequestHeaderSizeInBytes() {
            return this.mRequestHeaderSizeInBytes;
        }

        public long getRequestBodySizeInBytes() {
            return this.mRequestBodySizeInBytes;
        }

        public long getResponseHeaderSizeInBytes() {
            return this.mResponseHeaderSizeInBytes;
        }

        public long getResponseBodySizeInBytes() {
            return this.mResponseBodySizeInBytes;
        }

        public int getResponseStatusCode() {
            return this.mResponseStatusCode;
        }

        public Duration getHeadersLatency() {
            return this.mHeadersLatency;
        }

        public Duration getTotalLatency() {
            return this.mTotalLatency;
        }

        public String getNegotiatedProtocol() {
            return this.mNegotiatedProtocol;
        }

        public boolean wasConnectionMigrationAttempted() {
            return this.mWasConnectionMigrationAttempted;
        }

        public boolean didConnectionMigrationSucceed() {
            return this.mDidConnectionMigrationSucceed;
        }

        public RequestTerminalState getTerminalState() {
            return this.mTerminalState;
        }

        public int getNonfinalUserCallbackExceptionCount() {
            return this.mNonfinalUserCallbackExceptionCount;
        }

        public int getReadCount() {
            return this.mReadCount;
        }

        public int getOnUploadReadCount() {
            return this.mOnUploadReadCount;
        }

        public boolean getIsBidiStream() {
            return this.mIsBidiStream;
        }

        public boolean getFinalUserCallbackThrew() {
            return this.mFinalUserCallbackThrew;
        }

        public int getUid() {
            return this.mUid;
        }

        public int getNetworkInternalErrorCode() {
            return this.mNetworkInternalErrorCode;
        }

        public int getQuicErrorCode() {
            return this.mQuicErrorCode;
        }

        public int getConnectionCloseSource() {
            return this.mSource;
        }

        public RequestFailureReason getFailureReason() {
            return this.mFailureReason;
        }

        public boolean getIsSocketReused() {
            return this.mSocketReused;
        }

        public static enum RequestTerminalState {
            SUCCEEDED,
            ERROR,
            CANCELLED;

        }

        public static enum RequestFailureReason {
            UNKNOWN,
            NETWORK,
            OTHER;

        }
    }

    public static class CronetEngineBuilderInfo {
        private final boolean mPublicKeyPinningBypassForLocalTrustAnchorsEnabled;
        private final String mUserAgent;
        private final String mStoragePath;
        private final boolean mQuicEnabled;
        private final boolean mHttp2Enabled;
        private final boolean mBrotiEnabled;
        private final int mHttpCacheMode;
        private final String mExperimentalOptions;
        private final boolean mNetworkQualityEstimatorEnabled;
        private final int mThreadPriority;
        private final long mCronetInitializationRef;

        public CronetEngineBuilderInfo(boolean publicKeyPinningBypassForLocalTrustAnchorsEnabled, String userAgent, String storagePath, boolean quicEnabled, boolean http2Enabled, boolean brotiEnabled, int httpCacheMode, String experimentalOptions, boolean networkQualityEstimatorEnabled, int threadPriority, long cronetInitializationRef) {
            this.mPublicKeyPinningBypassForLocalTrustAnchorsEnabled = publicKeyPinningBypassForLocalTrustAnchorsEnabled;
            this.mUserAgent = userAgent;
            this.mStoragePath = storagePath;
            this.mQuicEnabled = quicEnabled;
            this.mHttp2Enabled = http2Enabled;
            this.mBrotiEnabled = brotiEnabled;
            this.mHttpCacheMode = httpCacheMode;
            this.mExperimentalOptions = experimentalOptions;
            this.mNetworkQualityEstimatorEnabled = networkQualityEstimatorEnabled;
            this.mThreadPriority = threadPriority;
            this.mCronetInitializationRef = cronetInitializationRef;
        }

        public boolean isPublicKeyPinningBypassForLocalTrustAnchorsEnabled() {
            return this.mPublicKeyPinningBypassForLocalTrustAnchorsEnabled;
        }

        public String getUserAgent() {
            return this.mUserAgent;
        }

        public String getStoragePath() {
            return this.mStoragePath;
        }

        public boolean isQuicEnabled() {
            return this.mQuicEnabled;
        }

        public boolean isHttp2Enabled() {
            return this.mHttp2Enabled;
        }

        public boolean isBrotliEnabled() {
            return this.mBrotiEnabled;
        }

        public int getHttpCacheMode() {
            return this.mHttpCacheMode;
        }

        public String getExperimentalOptions() {
            return this.mExperimentalOptions;
        }

        public boolean isNetworkQualityEstimatorEnabled() {
            return this.mNetworkQualityEstimatorEnabled;
        }

        public int getThreadPriority() {
            return this.mThreadPriority;
        }

        public long getCronetInitializationRef() {
            return this.mCronetInitializationRef;
        }
    }

    public static class CronetInitializedInfo {
        public long cronetInitializationRef;
        public int engineCreationLatencyMillis = -1;
        public int engineAsyncLatencyMillis = -1;
        public int httpFlagsLatencyMillis = -1;
        public Boolean httpFlagsSuccessful;
        public List<Long> httpFlagsNames;
        public List<Long> httpFlagsValues;
    }

    public static class CronetEngineBuilderInitializedInfo {
        public long cronetInitializationRef;
        public Author author;
        public int engineBuilderCreatedLatencyMillis = -1;
        public CronetSource source = CronetSource.CRONET_SOURCE_UNSPECIFIED;
        public Boolean creationSuccessful;
        public CronetVersion apiVersion;
        public CronetVersion implVersion;
        public int uid;

        public static enum Author {
            API,
            IMPL;

        }
    }

    public static enum CronetSource {
        CRONET_SOURCE_UNSPECIFIED,
        CRONET_SOURCE_STATICALLY_LINKED,
        CRONET_SOURCE_PLAY_SERVICES,
        CRONET_SOURCE_FALLBACK,
        CRONET_SOURCE_PLATFORM,
        CRONET_SOURCE_FAKE;

    }
}

