/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.telemetry;

import android.net.connectivity.org.chromium.base.metrics.ScopedSysTraceEvent;
import android.net.connectivity.org.chromium.net.impl.CronetLogger;
import android.net.connectivity.org.chromium.net.telemetry.CronetStatsLog;
import android.net.connectivity.org.chromium.net.telemetry.ExperimentalOptions;
import android.net.connectivity.org.chromium.net.telemetry.Hash;
import android.net.connectivity.org.chromium.net.telemetry.OptionalBoolean;
import android.net.connectivity.org.chromium.net.telemetry.RateLimiter;
import android.net.connectivity.org.chromium.net.telemetry.SizeBuckets;
import android.os._Original_Build;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

@RequiresApi(value=30)
public class CronetLoggerImpl
extends CronetLogger {
    private static final String TAG = CronetLoggerImpl.class.getSimpleName();
    private final AtomicInteger mSamplesRateLimited = new AtomicInteger();
    private final RateLimiter mRateLimiter;

    public CronetLoggerImpl(int sampleRatePerSecond) {
        this(new RateLimiter(sampleRatePerSecond));
    }

    @VisibleForTesting
    public CronetLoggerImpl(RateLimiter rateLimiter) {
        this.mRateLimiter = rateLimiter;
    }

    @Override
    public long generateId() {
        long id2 = ThreadLocalRandom.current().nextLong(-9223372036854775807L, 0x7FFFFFFFFFFFFFFDL);
        return id2 >= -1L ? id2 + 2L : id2;
    }

    @Override
    public void logCronetEngineBuilderInitializedInfo(CronetLogger.CronetEngineBuilderInitializedInfo info) {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetLoggerImpl#logCronetEngineBuilderInitializedInfo");){
            CronetStatsLog.write(762, info.cronetInitializationRef, CronetLoggerImpl.convertToProtoCronetEngineBuilderInitializedAuthor(info.author), info.engineBuilderCreatedLatencyMillis, CronetLoggerImpl.convertToProtoCronetEngineBuilderInitializedSource(info.source), OptionalBoolean.fromBoolean(info.creationSuccessful).getValue(), info.apiVersion.getMajorVersion(), info.apiVersion.getMinorVersion(), info.apiVersion.getBuildVersion(), info.apiVersion.getPatchVersion(), info.implVersion == null ? -1 : info.implVersion.getMajorVersion(), info.implVersion == null ? -1 : info.implVersion.getMinorVersion(), info.implVersion == null ? -1 : info.implVersion.getBuildVersion(), info.implVersion == null ? -1 : info.implVersion.getPatchVersion(), info.uid);
        }
    }

    @Override
    public void logCronetInitializedInfo(CronetLogger.CronetInitializedInfo info) {
        if (_Original_Build.VERSION.SDK_INT < 33) {
            return;
        }
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetLoggerImpl#logCronetInitializedInfo");){
            CronetStatsLog.write(764, info.cronetInitializationRef, info.engineCreationLatencyMillis, info.engineAsyncLatencyMillis, info.httpFlagsLatencyMillis, OptionalBoolean.fromBoolean(info.httpFlagsSuccessful).getValue(), CronetLoggerImpl.longListToLongArray(info.httpFlagsNames), CronetLoggerImpl.longListToLongArray(info.httpFlagsValues));
        }
    }

    @Override
    public void logCronetEngineCreation(long cronetEngineId, CronetLogger.CronetEngineBuilderInfo builder, CronetLogger.CronetVersion version, CronetLogger.CronetSource source) {
        if (builder == null || version == null || source == null) {
            return;
        }
        this.writeCronetEngineCreation(cronetEngineId, builder, version, source);
    }

    @Override
    public void logCronetTrafficInfo(long cronetEngineId, CronetLogger.CronetTrafficInfo trafficInfo) {
        if (trafficInfo == null) {
            return;
        }
        if (!this.mRateLimiter.tryAcquire()) {
            this.mSamplesRateLimited.incrementAndGet();
            return;
        }
        this.writeCronetTrafficReported(cronetEngineId, trafficInfo, this.mSamplesRateLimited.getAndSet(0));
    }

    public void writeCronetEngineCreation(long cronetEngineId, CronetLogger.CronetEngineBuilderInfo builder, CronetLogger.CronetVersion version, CronetLogger.CronetSource source) {
        block8: {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetLoggerImpl#writeCronetEngineCreation");){
                ExperimentalOptions experimentalOptions = new ExperimentalOptions(builder.getExperimentalOptions());
                CronetStatsLog.write(703, cronetEngineId, version.getMajorVersion(), version.getMinorVersion(), version.getBuildVersion(), version.getPatchVersion(), CronetLoggerImpl.convertToProtoCronetEngineCreatedSource(source), builder.isBrotliEnabled(), builder.isHttp2Enabled(), CronetLoggerImpl.convertToProtoHttpCacheMode(builder.getHttpCacheMode()), builder.isPublicKeyPinningBypassForLocalTrustAnchorsEnabled(), builder.isQuicEnabled(), builder.isNetworkQualityEstimatorEnabled(), builder.getThreadPriority(), experimentalOptions.getConnectionOptionsOption(), experimentalOptions.getStoreServerConfigsInPropertiesOption().getValue(), experimentalOptions.getMaxServerConfigsStoredInPropertiesOption(), experimentalOptions.getIdleConnectionTimeoutSecondsOption(), experimentalOptions.getGoawaySessionsOnIpChangeOption().getValue(), experimentalOptions.getCloseSessionsOnIpChangeOption().getValue(), experimentalOptions.getMigrateSessionsOnNetworkChangeV2Option().getValue(), experimentalOptions.getMigrateSessionsEarlyV2().getValue(), experimentalOptions.getDisableBidirectionalStreamsOption().getValue(), experimentalOptions.getMaxTimeBeforeCryptoHandshakeSecondsOption(), experimentalOptions.getMaxIdleTimeBeforeCryptoHandshakeSecondsOption(), experimentalOptions.getEnableSocketRecvOptimizationOption().getValue(), experimentalOptions.getAsyncDnsEnableOption().getValue(), experimentalOptions.getStaleDnsEnableOption().getValue(), experimentalOptions.getStaleDnsDelayMillisOption(), experimentalOptions.getStaleDnsMaxExpiredTimeMillisOption(), experimentalOptions.getStaleDnsMaxStaleUsesOption(), experimentalOptions.getStaleDnsAllowOtherNetworkOption().getValue(), experimentalOptions.getStaleDnsPersistToDiskOption().getValue(), experimentalOptions.getStaleDnsPersistDelayMillisOption(), experimentalOptions.getStaleDnsUseStaleOnNameNotResolvedOption().getValue(), experimentalOptions.getDisableIpv6OnWifiOption().getValue(), builder.getCronetInitializationRef());
            }
            catch (Exception e) {
                if (!Log.isLoggable(TAG, 3)) break block8;
                Log.d(TAG, String.format("Failed to log CronetEngine:%s creation: %s", cronetEngineId, e.getMessage()));
            }
        }
    }

    @VisibleForTesting
    public void writeCronetTrafficReported(long cronetEngineId, CronetLogger.CronetTrafficInfo trafficInfo, int samplesRateLimitedCount) {
        block8: {
            try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped("CronetLoggerImpl#writeCronetTrafficReported");){
                CronetStatsLog.write(704, cronetEngineId, SizeBuckets.calcRequestHeadersSizeBucket(trafficInfo.getRequestHeaderSizeInBytes()), SizeBuckets.calcRequestBodySizeBucket(trafficInfo.getRequestBodySizeInBytes()), SizeBuckets.calcResponseHeadersSizeBucket(trafficInfo.getResponseHeaderSizeInBytes()), SizeBuckets.calcResponseBodySizeBucket(trafficInfo.getResponseBodySizeInBytes()), trafficInfo.getResponseStatusCode(), Hash.hash(trafficInfo.getNegotiatedProtocol()), (int)trafficInfo.getHeadersLatency().toMillis(), (int)trafficInfo.getTotalLatency().toMillis(), trafficInfo.wasConnectionMigrationAttempted(), trafficInfo.didConnectionMigrationSucceed(), samplesRateLimitedCount, CronetLoggerImpl.convertToProtoCronetRequestTerminalState(trafficInfo.getTerminalState()), trafficInfo.getNonfinalUserCallbackExceptionCount(), -1L, -1L, trafficInfo.getReadCount(), trafficInfo.getOnUploadReadCount(), OptionalBoolean.fromBoolean(trafficInfo.getIsBidiStream()).getValue(), OptionalBoolean.fromBoolean(trafficInfo.getFinalUserCallbackThrew()).getValue(), trafficInfo.getUid(), trafficInfo.getNetworkInternalErrorCode(), trafficInfo.getQuicErrorCode(), CronetLoggerImpl.convertToProtoConnectionCloseSource(trafficInfo.getConnectionCloseSource()), CronetLoggerImpl.convertToProtoFailureReason(trafficInfo.getFailureReason()), OptionalBoolean.fromBoolean(trafficInfo.getIsSocketReused()).getValue());
            }
            catch (Exception e) {
                this.mSamplesRateLimited.addAndGet(samplesRateLimitedCount);
                if (!Log.isLoggable(TAG, 3)) break block8;
                Log.d(TAG, String.format("Failed to log cronet traffic sample for CronetEngine %s: %s", cronetEngineId, e.getMessage()));
            }
        }
    }

    private static int convertToProtoFailureReason(CronetLogger.CronetTrafficInfo.RequestFailureReason failureReason) {
        switch (failureReason) {
            case NETWORK: {
                return 1;
            }
            case OTHER: {
                return 100;
            }
        }
        return 0;
    }

    private static int convertToProtoConnectionCloseSource(int source) {
        switch (source) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    private static int convertToProtoCronetEngineBuilderInitializedAuthor(CronetLogger.CronetEngineBuilderInitializedInfo.Author author) {
        switch (author) {
            case API: {
                return 1;
            }
            case IMPL: {
                return 2;
            }
        }
        return 0;
    }

    private static int convertToProtoCronetRequestTerminalState(CronetLogger.CronetTrafficInfo.RequestTerminalState requestTerminalState) {
        switch (requestTerminalState) {
            case SUCCEEDED: {
                return 1;
            }
            case ERROR: {
                return 2;
            }
            case CANCELLED: {
                return 3;
            }
        }
        return 0;
    }

    private static int convertToProtoCronetEngineBuilderInitializedSource(CronetLogger.CronetSource source) {
        switch (source) {
            case CRONET_SOURCE_STATICALLY_LINKED: {
                return 1;
            }
            case CRONET_SOURCE_PLAY_SERVICES: {
                return 2;
            }
            case CRONET_SOURCE_FALLBACK: {
                return 3;
            }
            case CRONET_SOURCE_PLATFORM: {
                return 4;
            }
        }
        return 0;
    }

    private static int convertToProtoCronetEngineCreatedSource(CronetLogger.CronetSource source) {
        switch (source) {
            case CRONET_SOURCE_STATICALLY_LINKED: {
                return 1;
            }
            case CRONET_SOURCE_PLAY_SERVICES: {
                return 2;
            }
            case CRONET_SOURCE_FALLBACK: {
                return 3;
            }
            case CRONET_SOURCE_UNSPECIFIED: {
                return 0;
            }
        }
        return 0;
    }

    private static int convertToProtoHttpCacheMode(int httpCacheMode) {
        switch (httpCacheMode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Expected httpCacheMode to range from 0 to 3");
    }

    private static long[] longListToLongArray(List<Long> list) {
        long[] array2 = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array2[i] = list.get(i);
        }
        return array2;
    }
}

