/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.connectivity.org.chromium.net.BidirectionalStream;
import android.net.connectivity.org.chromium.net.ExperimentalCronetEngine;
import android.net.http.BidirectionalStream;
import android.net.http.BidirectionalStreamCallbackWrapper;
import android.net.http.BidirectionalStreamWrapper;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class BidirectionalStreamBuilderWrapper
extends BidirectionalStream.Builder {
    private Consumer<BidirectionalStream.Builder> mBuilderMutator = builder -> {};
    private Consumer<BidirectionalStreamWrapper> mWrapperMutator = wrapper -> {};
    private BidirectionalStreamCallbackWrapper mCallbackWrapper;
    private BidirectionalStream.Builder mBackend;
    private final ExperimentalCronetEngine mCronetEngine;
    private final String mUrl;
    private final Executor mExecutor;
    private final BidirectionalStream.Callback mCallback;

    public BidirectionalStreamBuilderWrapper(ExperimentalCronetEngine cronetEngine, String url, Executor executor, BidirectionalStream.Callback callback) {
        this.mCronetEngine = cronetEngine;
        this.mUrl = url;
        this.mExecutor = executor;
        this.mCallback = callback;
        this.mCallbackWrapper = new BidirectionalStreamCallbackWrapper(this.mCallback);
        this.mBackend = this.mCronetEngine.newBidirectionalStreamBuilder(this.mUrl, this.mCallbackWrapper, this.mExecutor);
    }

    private void mutate(Consumer<BidirectionalStream.Builder> builderMutator, Consumer<BidirectionalStreamWrapper> wrapperMutator) {
        this.maybeCreateBackendAndApplyMutator();
        this.mBuilderMutator = this.mBuilderMutator.andThen(builderMutator);
        builderMutator.accept(this.mBackend);
        this.mWrapperMutator = this.mWrapperMutator.andThen(wrapperMutator);
    }

    @Override
    public BidirectionalStream.Builder setHttpMethod(String method) {
        this.mutate(builder -> builder.setHttpMethod(method), wrapper -> wrapper.setHttpMethod(method));
        return this;
    }

    @Override
    public BidirectionalStream.Builder addHeader(String header, String value) {
        this.mutate(builder -> builder.addHeader(header, value), wrapper -> wrapper.addHeader(header, value));
        return this;
    }

    @Override
    public BidirectionalStream.Builder setPriority(int priority) {
        this.mutate(builder -> builder.setPriority(priority), wrapper -> wrapper.setPriority(priority));
        return this;
    }

    @Override
    public BidirectionalStream.Builder setDelayRequestHeadersUntilFirstFlushEnabled(boolean delayRequestHeadersUntilFirstFlush) {
        this.mutate(builder -> builder.delayRequestHeadersUntilFirstFlush(delayRequestHeadersUntilFirstFlush), wrapper -> wrapper.setDelayRequestHeadersUntilFirstFlushEnabled(delayRequestHeadersUntilFirstFlush));
        return this;
    }

    private void maybeCreateBackendAndApplyMutator() {
        if (this.mBackend != null) {
            return;
        }
        this.mCallbackWrapper = new BidirectionalStreamCallbackWrapper(this.mCallback);
        this.mBackend = this.mCronetEngine.newBidirectionalStreamBuilder(this.mUrl, this.mCallbackWrapper, this.mExecutor);
        this.mBuilderMutator.accept(this.mBackend);
    }

    @Override
    public BidirectionalStream build() {
        this.maybeCreateBackendAndApplyMutator();
        BidirectionalStreamWrapper wrapper = new BidirectionalStreamWrapper(this.mBackend.build());
        this.mWrapperMutator.accept(wrapper);
        this.mCallbackWrapper.setOriginalStreamWrapper(wrapper);
        this.mBackend = null;
        return wrapper;
    }

    @Override
    @NonNull
    public BidirectionalStream.Builder setTrafficStatsTag(int tag) {
        this.mutate(builder -> builder.setTrafficStatsTag(tag), wrapper -> wrapper.setTrafficStatsTag(tag));
        return this;
    }

    @Override
    @NonNull
    public BidirectionalStream.Builder setTrafficStatsUid(int uid) {
        this.mutate(builder -> builder.setTrafficStatsUid(uid), wrapper -> wrapper.setTrafficStatsUid(uid));
        return this;
    }
}

