/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.connectivity.org.chromium.net.CallbackException;
import android.net.connectivity.org.chromium.net.CronetException;
import android.net.connectivity.org.chromium.net.NetworkException;
import android.net.connectivity.org.chromium.net.QuicException;
import android.net.http.CallbackExceptionWrapper;
import android.net.http.CronetExceptionWrapper;
import android.net.http.HttpException;
import android.net.http.InlineExecutionProhibitedException;
import android.net.http.NetworkExceptionWrapper;
import android.net.http.QuicExceptionWrapper;
import java.io.IOException;

public class CronetExceptionTranslationUtils {
    private CronetExceptionTranslationUtils() {
    }

    public static <T> T executeTranslatingExceptions(CronetRunnable<T> work) throws IOException {
        try {
            return work.run();
        }
        catch (CronetException e) {
            throw CronetExceptionTranslationUtils.translateException(e);
        }
    }

    public static HttpException translateException(CronetException e) {
        if (e instanceof QuicException) {
            return new QuicExceptionWrapper((QuicException)e);
        }
        if (e instanceof NetworkException) {
            return new NetworkExceptionWrapper((NetworkException)e);
        }
        if (e instanceof CallbackException) {
            return new CallbackExceptionWrapper((CallbackException)e);
        }
        return new CronetExceptionWrapper(e);
    }

    public static Throwable maybeTranslateException(Throwable t) {
        if (t instanceof android.net.connectivity.org.chromium.net.InlineExecutionProhibitedException) {
            InlineExecutionProhibitedException translatedException = new InlineExecutionProhibitedException();
            translatedException.initCause(t);
            return translatedException;
        }
        return t;
    }

    public static interface CronetRunnable<T> {
        public T run() throws IOException;
    }
}

