/*
 * Decompiled with CFR 0.152.
 */
package android.net.thread;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.net.thread.flags.thread_enabled")
public class OperationalDatasetTimestamp {
    public static final int LENGTH_TIMESTAMP = 8;
    private static final int TICKS_UPPER_BOUND = 32768;
    private final long mSeconds;
    private final int mTicks;
    private final boolean mIsAuthoritativeSource;

    @NonNull
    public static OperationalDatasetTimestamp fromInstant(@NonNull Instant instant) {
        return OperationalDatasetTimestamp.fromInstant(instant, true);
    }

    @NonNull
    public static OperationalDatasetTimestamp fromInstant(@NonNull Instant instant, boolean isAuthoritativeSource) {
        int ticks = OperationalDatasetTimestamp.getRoundedTicks(instant.getNano());
        long seconds = instant.getEpochSecond() + (long)(ticks / 32768);
        return new OperationalDatasetTimestamp(seconds, ticks %= 32768, isAuthoritativeSource);
    }

    @NonNull
    public Instant toInstant() {
        long nanos = Math.round((double)this.mTicks * 1.0E9 / 32768.0);
        return Instant.ofEpochSecond(this.mSeconds, nanos);
    }

    @NonNull
    public static OperationalDatasetTimestamp fromTlvValue(@NonNull byte[] encodedTimestamp) {
        Objects.requireNonNull(encodedTimestamp, "encodedTimestamp cannot be null");
        Preconditions.checkArgument(encodedTimestamp.length == 8, "Invalid Thread OperationalDatasetTimestamp length (length = %d, expectedLength=%d)", encodedTimestamp.length, 8);
        long longTimestamp = ByteBuffer.wrap(encodedTimestamp).getLong();
        return new OperationalDatasetTimestamp(longTimestamp >> 16 & 0xFFFFFFFFFFFFL, (int)(longTimestamp >> 1 & 0x7FFFL), (longTimestamp & 1L) != 0L);
    }

    @NonNull
    public byte[] toTlvValue() {
        byte[] tlv = new byte[8];
        ByteBuffer buffer = ByteBuffer.wrap(tlv);
        long encodedValue = this.mSeconds << 16 | (long)(this.mTicks << 1) | (long)(this.mIsAuthoritativeSource ? 1 : 0);
        buffer.putLong(encodedValue);
        return tlv;
    }

    public OperationalDatasetTimestamp(long seconds, int ticks, boolean isAuthoritativeSource) {
        Preconditions.checkArgument(seconds >= 0L && seconds <= 0xFFFFFFFFFFFFL, "seconds exceeds allowed range (seconds = %d, allowedRange = [0x0, 0xffffffffffffL])", seconds);
        Preconditions.checkArgument(ticks >= 0 && ticks <= Short.MAX_VALUE, "ticks exceeds allowed ranged (ticks = %d, allowedRange = [0x0, 0x7fff])", ticks);
        this.mSeconds = seconds;
        this.mTicks = ticks;
        this.mIsAuthoritativeSource = isAuthoritativeSource;
    }

    private static int getRoundedTicks(long nanos) {
        return (int)Math.round((double)nanos * 32768.0 / 1.0E9);
    }

    public long getSeconds() {
        return this.mSeconds;
    }

    public int getTicks() {
        return this.mTicks;
    }

    public boolean isAuthoritativeSource() {
        return this.mIsAuthoritativeSource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{seconds=").append(this.getSeconds()).append(", ticks=").append(this.getTicks()).append(", isAuthoritativeSource=").append(this.isAuthoritativeSource()).append(", instant=").append(this.toInstant()).append("}");
        return sb.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OperationalDatasetTimestamp)) {
            return false;
        }
        OperationalDatasetTimestamp otherTimestamp = (OperationalDatasetTimestamp)other;
        return this.mSeconds == otherTimestamp.mSeconds && this.mTicks == otherTimestamp.mTicks && this.mIsAuthoritativeSource == otherTimestamp.mIsAuthoritativeSource;
    }

    public int hashCode() {
        return Objects.hash(this.mSeconds, this.mTicks, this.mIsAuthoritativeSource);
    }
}

