/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IByteArrayListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IByteArrayListener";

    public void onResult(byte[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IByteArrayListener {
        static final int TRANSACTION_onResult = 1;

        public Stub() {
            this.attachInterface(this, IByteArrayListener.DESCRIPTOR);
        }

        public static IByteArrayListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IByteArrayListener.DESCRIPTOR);
            if (iin != null && iin instanceof IByteArrayListener) {
                return (IByteArrayListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IByteArrayListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    byte[] _arg0 = data.createByteArray();
                    this.onResult(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IByteArrayListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IByteArrayListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(byte[] byteArray) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IByteArrayListener.DESCRIPTOR);
                    _data.writeByteArray(byteArray);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IByteArrayListener {
        @Override
        public void onResult(byte[] byteArray) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

