/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
public class MscsParams
implements Parcelable {
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_IP_VERSION = 1;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_SRC_IP_ADDR = 2;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_DST_IP_ADDR = 4;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_SRC_PORT = 8;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_DST_PORT = 16;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_DSCP = 32;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_PROTOCOL_NEXT_HDR = 64;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static final int FRAME_CLASSIFIER_FLOW_LABEL = 128;
    public static final int DEFAULT_FRAME_CLASSIFIER_FIELDS = 95;
    public static final int DEFAULT_USER_PRIORITY_BITMAP = 192;
    public static final int DEFAULT_USER_PRIORITY_LIMIT = 7;
    public static final int MAX_STREAM_TIMEOUT_US = 60000000;
    private final int mFrameClassifierFields;
    private final int mUserPriorityBitmap;
    private final int mUserPriorityLimit;
    private final int mStreamTimeoutUs;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public static final Parcelable.Creator<MscsParams> CREATOR = new Parcelable.Creator<MscsParams>(){

        @Override
        public MscsParams createFromParcel(Parcel in) {
            return new MscsParams(in);
        }

        public MscsParams[] newArray(int size) {
            return new MscsParams[size];
        }
    };

    private MscsParams(int frameClassifierFields, int userPriorityBitmap, int userPriorityLimit, int streamTimeoutUs) {
        this.mFrameClassifierFields = frameClassifierFields;
        this.mUserPriorityBitmap = userPriorityBitmap;
        this.mUserPriorityLimit = userPriorityLimit;
        this.mStreamTimeoutUs = streamTimeoutUs;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getFrameClassifierFields() {
        return this.mFrameClassifierFields;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getUserPriorityBitmap() {
        return this.mUserPriorityBitmap;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getUserPriorityLimit() {
        return this.mUserPriorityLimit;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getStreamTimeoutUs() {
        return this.mStreamTimeoutUs;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MscsParams that = (MscsParams)o;
        return this.mFrameClassifierFields == that.mFrameClassifierFields && this.mUserPriorityBitmap == that.mUserPriorityBitmap && this.mUserPriorityLimit == that.mUserPriorityLimit && this.mStreamTimeoutUs == that.mStreamTimeoutUs;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int hashCode() {
        return Objects.hash(this.mFrameClassifierFields, this.mUserPriorityBitmap, this.mUserPriorityLimit, this.mStreamTimeoutUs);
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFrameClassifierFields);
        dest.writeInt(this.mUserPriorityBitmap);
        dest.writeInt(this.mUserPriorityLimit);
        dest.writeInt(this.mStreamTimeoutUs);
    }

    MscsParams(@NonNull Parcel in) {
        this.mFrameClassifierFields = in.readInt();
        this.mUserPriorityBitmap = in.readInt();
        this.mUserPriorityLimit = in.readInt();
        this.mStreamTimeoutUs = in.readInt();
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static class Builder {
        private int mFrameClassifierFields = 95;
        private int mUserPriorityBitmap = 192;
        private int mUserPriorityLimit = 7;
        private int mStreamTimeoutUs = 60000000;

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        public Builder() {
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setFrameClassifierFields(int frameClassifierFields) {
            if ((frameClassifierFields & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("frameClassifierFields can only use bits 0-7");
            }
            this.mFrameClassifierFields = frameClassifierFields;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setUserPriorityBitmap(int userPriorityBitmap) {
            if ((userPriorityBitmap & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("userPriorityBitmap can only use bits 0-7");
            }
            this.mUserPriorityBitmap = userPriorityBitmap;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setUserPriorityLimit(int userPriorityLimit) {
            if (userPriorityLimit < 0 || userPriorityLimit > 7) {
                throw new IllegalArgumentException("userPriorityLimit must be between 0-7 (inclusive)");
            }
            this.mUserPriorityLimit = userPriorityLimit;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setStreamTimeoutUs(int streamTimeoutUs) {
            if (streamTimeoutUs < 0 || streamTimeoutUs > 60000000) {
                throw new IllegalArgumentException("streamTimeoutUs must be 60 seconds or less");
            }
            this.mStreamTimeoutUs = streamTimeoutUs;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public MscsParams build() {
            return new MscsParams(this.mFrameClassifierFields, this.mUserPriorityBitmap, this.mUserPriorityLimit, this.mStreamTimeoutUs);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrameClassifierField {
    }
}

