/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.TetheringManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
public class SoftApState
implements Parcelable {
    final int mState;
    final int mFailureReason;
    @Nullable
    final TetheringManager.TetheringRequest mTetheringRequest;
    @Nullable
    final String mIface;
    @NonNull
    public static final Parcelable.Creator<SoftApState> CREATOR = new Parcelable.Creator<SoftApState>(){

        @Override
        @NonNull
        public SoftApState createFromParcel(Parcel in) {
            return new SoftApState(in);
        }

        @NonNull
        public SoftApState[] newArray(int size) {
            return new SoftApState[size];
        }
    };

    public SoftApState(int state, int failureReason, @Nullable TetheringManager.TetheringRequest tetheringRequest, @Nullable String iface) {
        this.mState = state;
        this.mFailureReason = failureReason;
        this.mTetheringRequest = tetheringRequest;
        this.mIface = iface;
    }

    private SoftApState(@NonNull Parcel in) {
        this.mState = in.readInt();
        this.mFailureReason = in.readInt();
        this.mTetheringRequest = SdkLevel.isAtLeastV() ? (TetheringManager.TetheringRequest)in.readParcelable(TetheringManager.TetheringRequest.class.getClassLoader()) : null;
        this.mIface = in.readString();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mState);
        dest.writeInt(this.mFailureReason);
        if (SdkLevel.isAtLeastV()) {
            dest.writeParcelable(this.mTetheringRequest, flags);
        }
        dest.writeString(this.mIface);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getState() {
        return this.mState;
    }

    public int getFailureReason() {
        if (this.mState != 14) {
            throw new IllegalStateException("Called getFailureReason() when state is not WIFI_AP_STATE_FAILED. Actual state is " + this.mState);
        }
        return this.getFailureReasonInternal();
    }

    public int getFailureReasonInternal() {
        return this.mFailureReason;
    }

    @Nullable
    public TetheringManager.TetheringRequest getTetheringRequest() {
        return this.mTetheringRequest;
    }

    @Nullable
    public String getIface() {
        return this.mIface;
    }

    public String toString() {
        return "SoftApState{mState=" + this.mState + ", mFailureReason=" + this.mFailureReason + ", mTetheringRequest=" + this.mTetheringRequest + ", mIface='" + this.mIface + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftApState)) {
            return false;
        }
        SoftApState stateInfo = (SoftApState)o;
        return this.mState == stateInfo.mState && this.mFailureReason == stateInfo.mFailureReason && Objects.equals(this.mTetheringRequest, stateInfo.mTetheringRequest) && Objects.equals(this.mIface, stateInfo.mIface);
    }

    public int hashCode() {
        return Objects.hash(this.mState, this.mFailureReason, this.mTetheringRequest, this.mIface);
    }
}

