/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.net.wifi.aware.Characteristics;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class AwarePairingConfig
implements Parcelable {
    public static final int PAIRING_BOOTSTRAPPING_OPPORTUNISTIC = 1;
    public static final int PAIRING_BOOTSTRAPPING_PIN_CODE_DISPLAY = 2;
    public static final int PAIRING_BOOTSTRAPPING_PASSPHRASE_DISPLAY = 4;
    public static final int PAIRING_BOOTSTRAPPING_QR_DISPLAY = 8;
    public static final int PAIRING_BOOTSTRAPPING_NFC_TAG = 16;
    public static final int PAIRING_BOOTSTRAPPING_PIN_CODE_KEYPAD = 32;
    public static final int PAIRING_BOOTSTRAPPING_PASSPHRASE_KEYPAD = 64;
    public static final int PAIRING_BOOTSTRAPPING_QR_SCAN = 128;
    public static final int PAIRING_BOOTSTRAPPING_NFC_READER = 256;
    public static final int PAIRING_BOOTSTRAPPING_MAX = 512;
    private final boolean mPairingSetup;
    private final boolean mPairingCache;
    private final boolean mPairingVerification;
    private final int mBootstrappingMethods;
    private final int mCipherSuites;
    @NonNull
    public static final Parcelable.Creator<AwarePairingConfig> CREATOR = new Parcelable.Creator<AwarePairingConfig>(){

        @Override
        public AwarePairingConfig createFromParcel(@NonNull Parcel in) {
            return new AwarePairingConfig(in);
        }

        public AwarePairingConfig[] newArray(int size) {
            return new AwarePairingConfig[size];
        }
    };

    public boolean isPairingCacheEnabled() {
        return this.mPairingCache;
    }

    public boolean isPairingSetupEnabled() {
        return this.mPairingSetup;
    }

    public boolean isPairingVerificationEnabled() {
        return this.mPairingVerification;
    }

    public int getBootstrappingMethods() {
        return this.mBootstrappingMethods;
    }

    @FlaggedApi(value="com.android.wifi.flags.aware_pairing")
    public int getSupportedCipherSuites() {
        return this.mCipherSuites;
    }

    public boolean assertValid(Characteristics characteristics) {
        if (this.mBootstrappingMethods < 0 || this.mBootstrappingMethods >= 512) {
            return false;
        }
        return (characteristics.getSupportedPairingCipherSuites() & this.mCipherSuites) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwarePairingConfig)) {
            return false;
        }
        AwarePairingConfig that = (AwarePairingConfig)o;
        return this.mPairingSetup == that.mPairingSetup && this.mPairingCache == that.mPairingCache && this.mPairingVerification == that.mPairingVerification && this.mBootstrappingMethods == that.mBootstrappingMethods && this.mCipherSuites == that.mCipherSuites;
    }

    public int hashCode() {
        return Objects.hash(this.mPairingSetup, this.mPairingCache, this.mPairingVerification, this.mBootstrappingMethods, this.mCipherSuites);
    }

    public AwarePairingConfig(boolean setup, boolean cache, boolean verification, int method, int cipherSuites) {
        this.mPairingSetup = setup;
        this.mPairingCache = cache;
        this.mPairingVerification = verification;
        this.mBootstrappingMethods = method;
        this.mCipherSuites = cipherSuites;
    }

    protected AwarePairingConfig(@NonNull Parcel in) {
        this.mPairingSetup = in.readBoolean();
        this.mPairingCache = in.readBoolean();
        this.mPairingVerification = in.readBoolean();
        this.mBootstrappingMethods = in.readInt();
        this.mCipherSuites = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mPairingSetup);
        dest.writeBoolean(this.mPairingCache);
        dest.writeBoolean(this.mPairingVerification);
        dest.writeInt(this.mBootstrappingMethods);
        dest.writeInt(this.mCipherSuites);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private boolean mPairingSetup = false;
        private boolean mPairingCache = false;
        private boolean mPairingVerification = false;
        private int mBootStrappingMethods = 0;
        private int mCipherSuites = 16;

        @NonNull
        public Builder setPairingSetupEnabled(boolean enabled) {
            this.mPairingSetup = enabled;
            return this;
        }

        @NonNull
        public Builder setPairingVerificationEnabled(boolean enabled) {
            this.mPairingVerification = enabled;
            return this;
        }

        @NonNull
        public Builder setPairingCacheEnabled(boolean enabled) {
            this.mPairingCache = enabled;
            return this;
        }

        @NonNull
        public Builder setBootstrappingMethods(int methods) {
            this.mBootStrappingMethods = methods;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.aware_pairing")
        @NonNull
        public Builder setSupportedCipherSuites(int cipherSuites) {
            this.mCipherSuites = cipherSuites;
            return this;
        }

        @NonNull
        public AwarePairingConfig build() {
            return new AwarePairingConfig(this.mPairingSetup, this.mPairingCache, this.mPairingVerification, this.mBootStrappingMethods, this.mCipherSuites);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BootstrappingMethod {
    }
}

