/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nl80211;

import android.net.wifi.nl80211.IApInterface;
import android.net.wifi.nl80211.IClientInterface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IInterfaceEventCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.nl80211.IInterfaceEventCallback";

    public void OnClientInterfaceReady(IClientInterface var1) throws RemoteException;

    public void OnApInterfaceReady(IApInterface var1) throws RemoteException;

    public void OnClientTorndownEvent(IClientInterface var1) throws RemoteException;

    public void OnApTorndownEvent(IApInterface var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInterfaceEventCallback {
        static final int TRANSACTION_OnClientInterfaceReady = 1;
        static final int TRANSACTION_OnApInterfaceReady = 2;
        static final int TRANSACTION_OnClientTorndownEvent = 3;
        static final int TRANSACTION_OnApTorndownEvent = 4;

        public Stub() {
            this.attachInterface(this, IInterfaceEventCallback.DESCRIPTOR);
        }

        public static IInterfaceEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInterfaceEventCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IInterfaceEventCallback) {
                return (IInterfaceEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "OnClientInterfaceReady";
                }
                case 2: {
                    return "OnApInterfaceReady";
                }
                case 3: {
                    return "OnClientTorndownEvent";
                }
                case 4: {
                    return "OnApTorndownEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInterfaceEventCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IClientInterface _arg0 = IClientInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.OnClientInterfaceReady(_arg0);
                    break;
                }
                case 2: {
                    IApInterface _arg0 = IApInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.OnApInterfaceReady(_arg0);
                    break;
                }
                case 3: {
                    IClientInterface _arg0 = IClientInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.OnClientTorndownEvent(_arg0);
                    break;
                }
                case 4: {
                    IApInterface _arg0 = IApInterface.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.OnApTorndownEvent(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IInterfaceEventCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInterfaceEventCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnClientInterfaceReady(IClientInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInterfaceEventCallback.DESCRIPTOR);
                    _data.writeStrongInterface(network_interface);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnApInterfaceReady(IApInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInterfaceEventCallback.DESCRIPTOR);
                    _data.writeStrongInterface(network_interface);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnClientTorndownEvent(IClientInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInterfaceEventCallback.DESCRIPTOR);
                    _data.writeStrongInterface(network_interface);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void OnApTorndownEvent(IApInterface network_interface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInterfaceEventCallback.DESCRIPTOR);
                    _data.writeStrongInterface(network_interface);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInterfaceEventCallback {
        @Override
        public void OnClientInterfaceReady(IClientInterface network_interface) throws RemoteException {
        }

        @Override
        public void OnApInterfaceReady(IApInterface network_interface) throws RemoteException {
        }

        @Override
        public void OnClientTorndownEvent(IClientInterface network_interface) throws RemoteException {
        }

        @Override
        public void OnApTorndownEvent(IApInterface network_interface) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

