/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;

@SystemApi
@FlaggedApi(value="android.net.wifi.flags.usd")
public class DiscoveryResult {
    private final int mPeerId;
    private final byte[] mServiceSpecificInfo;
    private final int mServiceProtoType;
    private final boolean mIsFsdEnabled;

    private DiscoveryResult(Builder builder) {
        this.mPeerId = builder.mPeerId;
        this.mServiceSpecificInfo = builder.mServiceSpecificInfo;
        this.mServiceProtoType = builder.mServiceProtoType;
        this.mIsFsdEnabled = builder.mIsFsdEnabled;
    }

    public int getPeerId() {
        return this.mPeerId;
    }

    @Nullable
    public byte[] getServiceSpecificInfo() {
        return this.mServiceSpecificInfo;
    }

    public int getServiceProtoType() {
        return this.mServiceProtoType;
    }

    public boolean isFsdEnabled() {
        return this.mIsFsdEnabled;
    }

    @FlaggedApi(value="android.net.wifi.flags.usd")
    public static class Builder {
        private final int mPeerId;
        private byte[] mServiceSpecificInfo;
        private int mServiceProtoType;
        private boolean mIsFsdEnabled;

        public Builder(int peerId) {
            this.mPeerId = peerId;
        }

        @NonNull
        public Builder setServiceSpecificInfo(@NonNull byte[] serviceSpecificInfo) {
            this.mServiceSpecificInfo = serviceSpecificInfo;
            return this;
        }

        @NonNull
        public Builder setServiceProtoType(int serviceProtoType) {
            this.mServiceProtoType = serviceProtoType;
            return this;
        }

        @NonNull
        public Builder setFsdEnabled(boolean isFsdEnabled) {
            this.mIsFsdEnabled = isFsdEnabled;
            return this;
        }

        @NonNull
        public DiscoveryResult build() {
            return new DiscoveryResult(this);
        }
    }
}

