/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresApi;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.net.wifi.usd.UsdManager;
import android.net.wifi.util.Environment;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
@RequiresApi(value=36)
@FlaggedApi(value="android.net.wifi.flags.usd")
public class SubscribeSession {
    private static final String TAG = SubscribeSession.class.getName();
    private final WeakReference<UsdManager> mUsdManager;
    private final int mSessionId;

    public SubscribeSession(@NonNull UsdManager usdManager, int sessionId) {
        this.mUsdManager = new WeakReference<UsdManager>(usdManager);
        this.mSessionId = sessionId;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void cancel() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        UsdManager usdManager = (UsdManager)this.mUsdManager.get();
        if (usdManager == null) {
            Log.w(TAG, "cancelSubscribe is called after the UsdManager has been garbage collected");
            return;
        }
        usdManager.cancelSubscribe(this.mSessionId);
    }

    @RequiresPermission(value="android.permission.MANAGE_WIFI_NETWORK_SELECTION")
    public void sendMessage(int peerId, @NonNull byte[] message, @NonNull Executor executor, @NonNull Consumer<Boolean> resultCallback) {
        Objects.requireNonNull(executor, "executor must not be null");
        Objects.requireNonNull(resultCallback, "resultCallback must not be null");
        Objects.requireNonNull(message, "message must not be null");
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        UsdManager usdManager = (UsdManager)this.mUsdManager.get();
        if (usdManager == null) {
            Log.w(TAG, "sendMessage is called after the UsdManager has been garbage collected");
            executor.execute(() -> resultCallback.accept(false));
            return;
        }
        usdManager.sendMessage(this.mSessionId, peerId, message, executor, resultCallback);
    }
}

