/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.ComponentNameAndUser;
import android.nfc.cardemulation.PollingFrame;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INfcEventCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.nfc.INfcEventCallback";

    public void onPreferredServiceChanged(ComponentNameAndUser var1) throws RemoteException;

    public void onObserveModeStateChanged(boolean var1) throws RemoteException;

    public void onObserveModeDisabledInFirmware(PollingFrame var1) throws RemoteException;

    public void onAidConflictOccurred(String var1) throws RemoteException;

    public void onAidNotRouted(String var1) throws RemoteException;

    public void onNfcStateChanged(int var1) throws RemoteException;

    public void onRemoteFieldChanged(boolean var1) throws RemoteException;

    public void onInternalErrorReported(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcEventCallback {
        static final int TRANSACTION_onPreferredServiceChanged = 1;
        static final int TRANSACTION_onObserveModeStateChanged = 2;
        static final int TRANSACTION_onObserveModeDisabledInFirmware = 3;
        static final int TRANSACTION_onAidConflictOccurred = 4;
        static final int TRANSACTION_onAidNotRouted = 5;
        static final int TRANSACTION_onNfcStateChanged = 6;
        static final int TRANSACTION_onRemoteFieldChanged = 7;
        static final int TRANSACTION_onInternalErrorReported = 8;

        public Stub() {
            this.attachInterface(this, INfcEventCallback.DESCRIPTOR);
        }

        public static INfcEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INfcEventCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INfcEventCallback) {
                return (INfcEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onPreferredServiceChanged";
                }
                case 2: {
                    return "onObserveModeStateChanged";
                }
                case 3: {
                    return "onObserveModeDisabledInFirmware";
                }
                case 4: {
                    return "onAidConflictOccurred";
                }
                case 5: {
                    return "onAidNotRouted";
                }
                case 6: {
                    return "onNfcStateChanged";
                }
                case 7: {
                    return "onRemoteFieldChanged";
                }
                case 8: {
                    return "onInternalErrorReported";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INfcEventCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ComponentNameAndUser _arg0 = data.readTypedObject(ComponentNameAndUser.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPreferredServiceChanged(_arg0);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onObserveModeStateChanged(_arg0);
                    break;
                }
                case 3: {
                    PollingFrame _arg0 = data.readTypedObject(PollingFrame.CREATOR);
                    data.enforceNoDataAvail();
                    this.onObserveModeDisabledInFirmware(_arg0);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAidConflictOccurred(_arg0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAidNotRouted(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNfcStateChanged(_arg0);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onRemoteFieldChanged(_arg0);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onInternalErrorReported(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements INfcEventCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INfcEventCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPreferredServiceChanged(ComponentNameAndUser ComponentNameAndUser2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeTypedObject(ComponentNameAndUser2, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onObserveModeStateChanged(boolean isEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onObserveModeDisabledInFirmware(PollingFrame exitFrame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeTypedObject(exitFrame, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAidConflictOccurred(String aid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeString(aid);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAidNotRouted(String aid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeString(aid);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNfcStateChanged(int nfcState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeInt(nfcState);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoteFieldChanged(boolean isDetected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeBoolean(isDetected);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInternalErrorReported(int errorType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(INfcEventCallback.DESCRIPTOR);
                    _data.writeInt(errorType);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INfcEventCallback {
        @Override
        public void onPreferredServiceChanged(ComponentNameAndUser ComponentNameAndUser2) throws RemoteException {
        }

        @Override
        public void onObserveModeStateChanged(boolean isEnabled) throws RemoteException {
        }

        @Override
        public void onObserveModeDisabledInFirmware(PollingFrame exitFrame) throws RemoteException {
        }

        @Override
        public void onAidConflictOccurred(String aid) throws RemoteException {
        }

        @Override
        public void onAidNotRouted(String aid) throws RemoteException {
        }

        @Override
        public void onNfcStateChanged(int nfcState) throws RemoteException {
        }

        @Override
        public void onRemoteFieldChanged(boolean isDetected) throws RemoteException {
        }

        @Override
        public void onInternalErrorReported(int errorType) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

